/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.hooks.item.tool.AxeItemHooks;
import dev.architectury.platform.Platform;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2248;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.satisfy.sleepy_hollows.Constants;
import net.satisfy.sleepy_hollows.client.event.HUDRenderEvent;
import net.satisfy.sleepy_hollows.core.event.ArmorEffectHandler;
import net.satisfy.sleepy_hollows.core.network.SleepyHollowsNetwork;
import net.satisfy.sleepy_hollows.core.network.message.SanityPacketMessage;
import net.satisfy.sleepy_hollows.core.registry.EntityTypeRegistry;
import net.satisfy.sleepy_hollows.core.registry.FeatureTypeRegistry;
import net.satisfy.sleepy_hollows.core.registry.FlammableBlockRegistry;
import net.satisfy.sleepy_hollows.core.registry.MobEffectRegistry;
import net.satisfy.sleepy_hollows.core.registry.ObjectRegistry;
import net.satisfy.sleepy_hollows.core.registry.SoundEventRegistry;
import net.satisfy.sleepy_hollows.core.registry.TabRegistry;
import net.satisfy.sleepy_hollows.core.registry.TagRegistry;
import net.satisfy.sleepy_hollows.core.util.SanityManager;
import net.satisfy.sleepy_hollows.core.world.SleepyHollowsBiomeKeys;

public final class SleepyHollows {
    public static void init() {
        ObjectRegistry.init();
        TabRegistry.init();
        MobEffectRegistry.init();
        EntityTypeRegistry.init();
        SoundEventRegistry.init();
        FeatureTypeRegistry.init();
        SleepyHollowsNetwork.init();
        ArmorEffectHandler.init();
        Constants.LOG.info("Sleepy Hollows has been initialized in the common setup phase.");
        if (Platform.getEnv() == EnvType.CLIENT) {
            ClientGuiEvent.RENDER_HUD.register(HUDRenderEvent::onRenderHUD);
        }
    }

    public static void commonInit() {
        FlammableBlockRegistry.init();
        AxeItemHooks.addStrippable((class_2248)((class_2248)ObjectRegistry.HOLLOW_LOG.get()), (class_2248)((class_2248)ObjectRegistry.STRIPPED_HOLLOW_LOG.get()));
        AxeItemHooks.addStrippable((class_2248)((class_2248)ObjectRegistry.HOLLOW_WOOD.get()), (class_2248)((class_2248)ObjectRegistry.STRIPPED_HOLLOW_WOOD.get()));
    }

    public static void onServerTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            if (SanityManager.getSanity(player) <= 0 && player.field_13974.method_14267()) {
                player.method_6092(new class_1293((class_1291)MobEffectRegistry.INSANITY.get(), 1200));
                SanityManager.changeSanity(player, 100);
                SleepyHollowsNetwork.SANITY_CHANNEL.sendToPlayer(player, (Object)new SanityPacketMessage(100));
            }
            if (server.method_3780() % 20 == 0) {
                SanityManager.doBlockCheck(player);
            }
            if (server.method_3780() % 100 != 0) continue;
            if (SanityManager.isImmune(player) || player.method_37908().method_8320(player.method_24515()).method_26164(TagRegistry.RESET_SANITY)) {
                return;
            }
            if (!player.method_37908().method_23753(player.method_23312()).method_40225(SleepyHollowsBiomeKeys.SLEEPY_HOLLOWS)) {
                SanityManager.changeSanity(player, SanityManager.Modifiers.OUTSIDE_BIOME.getValue());
                SleepyHollowsNetwork.SANITY_CHANNEL.sendToPlayer(player, (Object)new SanityPacketMessage(SanityManager.Modifiers.OUTSIDE_BIOME.getValue()));
                continue;
            }
            SanityManager.changeSanity(player, SanityManager.Modifiers.INSIDE_BIOME.getValue());
            SleepyHollowsNetwork.SANITY_CHANNEL.sendToPlayer(player, (Object)new SanityPacketMessage(SanityManager.Modifiers.INSIDE_BIOME.getValue()));
        }
    }
}

