/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.satisfy.sleepy_hollows.core.effect.BadDreamEffect;
import net.satisfy.sleepy_hollows.core.effect.InfectedEffect;
import net.satisfy.sleepy_hollows.core.effect.InsanityEffect;
import net.satisfy.sleepy_hollows.core.effect.MentalFortitudeEffect;
import net.satisfy.sleepy_hollows.core.util.SleepyHollowsIdentifier;

public class MobEffectRegistry {
    private static final DeferredRegister<class_1291> MOB_EFFECTS = DeferredRegister.create((String)"sleepy_hollows", (class_5321)class_7924.field_41208);
    private static final Registrar<class_1291> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<class_1291> INSANITY = MobEffectRegistry.registerEffect("insanity", InsanityEffect::new);
    public static final RegistrySupplier<class_1291> INFECTED = MobEffectRegistry.registerEffect("infected", InfectedEffect::new);
    public static final RegistrySupplier<class_1291> MENTAL_FORTITUDE = MobEffectRegistry.registerEffect("mental_fortitude", MentalFortitudeEffect::new);
    public static final RegistrySupplier<class_1291> BAD_DREAM = MobEffectRegistry.registerEffect("bad_dream", BadDreamEffect::new);

    private static RegistrySupplier<class_1291> registerEffect(String name, Supplier<class_1291> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((class_2960)new SleepyHollowsIdentifier(name), effect);
    }

    public static void init() {
        MOB_EFFECTS.register();
    }
}

