/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.util;

import net.minecraft.class_1291;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.satisfy.sleepy_hollows.core.network.SleepyHollowsNetwork;
import net.satisfy.sleepy_hollows.core.network.message.SanityPacketMessage;
import net.satisfy.sleepy_hollows.core.registry.MobEffectRegistry;
import net.satisfy.sleepy_hollows.core.registry.TagRegistry;
import net.satisfy.sleepy_hollows.core.util.IEntitySavedData;

public class SanityManager {
    public static final String SANITY = "sanity";
    public static final int MINIMUM_SANITY = 0;
    public static final int MAXIMUM_SANITY = 100;

    private static int safeSanity(int amount) {
        if (amount < 0) {
            return 0;
        }
        if (amount > 100) {
            return 100;
        }
        return amount;
    }

    public static boolean isImmune(class_3222 player) {
        return player.method_6059((class_1291)MobEffectRegistry.MENTAL_FORTITUDE.get());
    }

    public static boolean isClientImmune(class_746 player) {
        return player.method_6059((class_1291)MobEffectRegistry.MENTAL_FORTITUDE.get());
    }

    public static IEntitySavedData getSavedData(class_3222 serverPlayer) {
        return (IEntitySavedData)serverPlayer;
    }

    public static IEntitySavedData getClientSavedData(class_746 clientPlayer) {
        return (IEntitySavedData)clientPlayer;
    }

    public static class_2487 getSanityTag(IEntitySavedData playerData) {
        return playerData.impl$getPersistentData();
    }

    public static class_2487 getClientSanityTag(IEntitySavedData playerData) {
        return playerData.impl$getPersistentData();
    }

    public static int getSanity(class_3222 player) {
        class_2487 nbt = SanityManager.getSanityTag(SanityManager.getSavedData(player));
        if (!nbt.method_10573(SANITY, 3)) {
            nbt.method_10569(SANITY, 100);
        }
        return nbt.method_10550(SANITY);
    }

    public static int getClientSanity(class_746 player) {
        class_2487 nbt = SanityManager.getSanityTag(SanityManager.getClientSavedData(player));
        if (!nbt.method_10573(SANITY, 3)) {
            nbt.method_10569(SANITY, 100);
        }
        return nbt.method_10550(SANITY);
    }

    public static void decreaseSanity(class_3222 player, int amount) {
        int currentSanity = SanityManager.getSanity(player);
        if (SanityManager.isImmune(player)) {
            return;
        }
        int newSanity = Math.max(0, currentSanity + amount);
        SanityManager.getSanityTag(SanityManager.getSavedData(player)).method_10569(SANITY, SanityManager.safeSanity(newSanity));
    }

    public static void decreaseClientSanity(class_746 player, int amount) {
        int currentSanity = SanityManager.getClientSanity(player);
        if (SanityManager.isClientImmune(player)) {
            return;
        }
        int newSanity = Math.max(0, currentSanity + amount);
        SanityManager.getClientSanityTag(SanityManager.getClientSavedData(player)).method_10569(SANITY, SanityManager.safeSanity(newSanity));
    }

    private static void increaseSanity(class_3222 player, int amount) {
        int currentSanity = SanityManager.getSanity(player);
        int newSanity = Math.min(100, currentSanity + amount);
        SanityManager.getSanityTag(SanityManager.getSavedData(player)).method_10569(SANITY, SanityManager.safeSanity(newSanity));
    }

    private static void increaseClientSanity(class_746 player, int amount) {
        int currentSanity = SanityManager.getClientSanity(player);
        int newSanity = Math.min(100, currentSanity + amount);
        SanityManager.getClientSanityTag(SanityManager.getClientSavedData(player)).method_10569(SANITY, SanityManager.safeSanity(newSanity));
    }

    public static void changeSanity(class_3222 player, int amount) {
        if (SanityManager.isImmune(player)) {
            return;
        }
        if (amount != 0) {
            if (amount > 0) {
                SanityManager.increaseSanity(player, amount);
            } else {
                SanityManager.decreaseSanity(player, amount);
            }
        }
    }

    public static void changeClientSanity(class_746 player, int amount) {
        if (SanityManager.isClientImmune(player)) {
            return;
        }
        if (amount != 0) {
            if (amount > 0) {
                SanityManager.increaseClientSanity(player, amount);
            } else {
                SanityManager.decreaseClientSanity(player, amount);
            }
        }
    }

    public static void doBlockCheck(class_3222 serverPlayer) {
        class_2338 blockPos;
        class_1937 level = serverPlayer.method_37908();
        class_2680 blockState = level.method_8320(blockPos = serverPlayer.method_24515());
        if (blockState.method_26164(TagRegistry.RESET_SANITY)) {
            SanityManager.changeSanity(serverPlayer, Modifiers.RESET_SANITY.getValue());
            SleepyHollowsNetwork.SANITY_CHANNEL.sendToPlayer(serverPlayer, (Object)new SanityPacketMessage(Modifiers.RESET_SANITY.getValue()));
        }
        if (!SanityManager.isImmune(serverPlayer) && blockState.method_26164(TagRegistry.DECREASE_SANITY)) {
            SanityManager.changeSanity(serverPlayer, Modifiers.DECREASE_SANITY.getValue());
            SleepyHollowsNetwork.SANITY_CHANNEL.sendToPlayer(serverPlayer, (Object)new SanityPacketMessage(Modifiers.DECREASE_SANITY.getValue()));
        }
    }

    public static boolean isSanityBarVisible(class_746 player) {
        return SanityManager.getClientSanity(player) < 100;
    }

    public static enum Modifiers {
        CANDY_CORN(4),
        DUSK_BERRY(2),
        LUMINOUS_WATER(6),
        SPECTRAL_PUMPKIN_PIE(10),
        INSIDE_BIOME(-1),
        OUTSIDE_BIOME(5),
        RESET_SANITY(100),
        DECREASE_SANITY(-2),
        INFECTED_EFFECT(-2),
        MENTAL_FORTITUDE(100);

        final int value;

        private Modifiers(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

