/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.sleepy_hollows.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class SoulfireSpiral {
    private final class_243 center;
    private final double y;
    private final int totalPoints = 800;
    private int currentPoint = 0;
    private final class_1937 level;
    private final List<SoulfireBlock> activeSoulfireBlocks = new ArrayList<SoulfireBlock>();

    public SoulfireSpiral(class_1937 level, class_243 center) {
        this.level = level;
        this.center = center;
        this.y = center.field_1351;
    }

    public boolean isFinished() {
        return this.currentPoint >= 800;
    }

    public void tick() {
        int pointsPerTick = 5;
        int i = 0;
        while (i < pointsPerTick && this.currentPoint < 800) {
            double angle = (double)this.currentPoint * 0.05;
            double radius = 0.6 * angle * 0.67;
            double x = this.center.field_1352 + radius * Math.cos(angle);
            double z = this.center.field_1350 + radius * Math.sin(angle);
            double y = this.y + 0.3;
            class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
            class_2338 belowPos = pos.method_10074();
            if (this.level.method_22347(pos) && this.level.method_8320(belowPos).method_26225()) {
                this.level.method_8652(pos, class_2246.field_22089.method_9564(), 3);
                this.activeSoulfireBlocks.add(new SoulfireBlock(pos));
            }
            this.sendParticles(x, y, z);
            class_1937 class_19372 = this.level;
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                this.ignitePlayersNearby(serverLevel, x, y, z);
            }
            ++i;
            ++this.currentPoint;
        }
        this.cleanupSoulfireBlocks();
    }

    private void sendParticles(double x, double y, double z) {
        class_1937 class_19372 = this.level;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_22246, x, y, z, 2, 0.2, 0.2, 0.2, 0.05);
            serverLevel.method_14199((class_2394)class_2398.field_22247, x, y, z, 1, 0.2, 0.2, 0.2, 0.05);
            if (this.currentPoint % 80 == 0) {
                serverLevel.method_14199((class_2394)class_2398.field_11237, x, y + 1.0, z, 60, 1.0, 1.0, 1.0, 0.05);
            } else if (this.currentPoint % 53 == 0) {
                serverLevel.method_14199((class_2394)class_2398.field_17430, x, y + 1.0, z, 50, 1.0, 1.0, 1.0, 0.05);
            } else if (this.currentPoint % 160 == 0) {
                serverLevel.method_14199((class_2394)class_2398.field_22247, x, y + 1.0, z, 75, 1.0, 1.0, 1.0, 0.05);
            }
        }
    }

    private void ignitePlayersNearby(class_3218 serverLevel, double x, double y, double z) {
        class_238 detectionBox = new class_238(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5);
        List players = serverLevel.method_8390(class_1657.class, detectionBox, class_1301.field_6156);
        for (class_1657 player : players) {
            if (!(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            if (serverPlayer.field_13974.method_14257() != class_1934.field_9215) continue;
            serverPlayer.method_5639(8);
        }
    }

    private void cleanupSoulfireBlocks() {
        if (!this.level.method_8608() && !this.activeSoulfireBlocks.isEmpty()) {
            Iterator<SoulfireBlock> iterator = this.activeSoulfireBlocks.iterator();
            while (iterator.hasNext()) {
                SoulfireBlock sfBlock = iterator.next();
                --sfBlock.ticksRemaining;
                if (sfBlock.ticksRemaining > 0 || this.level.method_8320(sfBlock.pos).method_26204() != class_2246.field_22089) continue;
                this.level.method_8652(sfBlock.pos, class_2246.field_10124.method_9564(), 3);
                iterator.remove();
            }
        }
    }

    private static class SoulfireBlock {
        class_2338 pos;
        int ticksRemaining = 30;

        SoulfireBlock(class_2338 pos) {
            this.pos = pos;
        }
    }
}

