/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.callfromrapacosmo.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.callfromrapacosmo.init.CallFromRapaCosmoModScreens;
import net.mcreator.callfromrapacosmo.world.inventory.RadioGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class RadioGUIScreen
extends AbstractContainerScreen<RadioGUIMenu>
implements CallFromRapaCosmoModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    EditBox RadioInput;
    EditBox RadioOutput;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"call_from_rapa_cosmo:textures/screens/radio_gui.png");

    public RadioGUIScreen(RadioGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 159;
        this.imageHeight = 79;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("RadioInput")) {
                this.RadioInput.setValue(stringState);
            } else if (name.equals("RadioOutput")) {
                this.RadioOutput.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.RadioInput.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.RadioOutput.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"call_from_rapa_cosmo:textures/screens/radioleft.png"), this.leftPos + 134, this.topPos + 23, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"call_from_rapa_cosmo:textures/screens/radioright.png"), this.leftPos + 134, this.topPos + 51, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.RadioInput.isFocused()) {
            return this.RadioInput.keyPressed(key, b, c);
        }
        if (this.RadioOutput.isFocused()) {
            return this.RadioOutput.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String RadioInputValue = this.RadioInput.getValue();
        String RadioOutputValue = this.RadioOutput.getValue();
        super.resize(minecraft, width, height);
        this.RadioInput.setValue(RadioInputValue);
        this.RadioOutput.setValue(RadioOutputValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.call_from_rapa_cosmo.radio_gui.label_radio"), 6, 6, -12829636, false);
    }

    public void init() {
        super.init();
        this.RadioInput = new EditBox(this.font, this.leftPos + 10, this.topPos + 22, 118, 18, (Component)Component.translatable((String)"gui.call_from_rapa_cosmo.radio_gui.RadioInput"));
        this.RadioInput.setMaxLength(8192);
        this.RadioInput.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((RadioGUIMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "RadioInput", content, false);
            }
        });
        this.RadioInput.setHint((Component)Component.translatable((String)"gui.call_from_rapa_cosmo.radio_gui.RadioInput"));
        this.addWidget((GuiEventListener)this.RadioInput);
        this.RadioOutput = new EditBox(this.font, this.leftPos + 10, this.topPos + 50, 118, 18, (Component)Component.translatable((String)"gui.call_from_rapa_cosmo.radio_gui.RadioOutput"));
        this.RadioOutput.setMaxLength(8192);
        this.RadioOutput.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((RadioGUIMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "RadioOutput", content, false);
            }
        });
        this.RadioOutput.setHint((Component)Component.translatable((String)"gui.call_from_rapa_cosmo.radio_gui.RadioOutput"));
        this.addWidget((GuiEventListener)this.RadioOutput);
    }
}

