/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.callfromrapacosmo.client.renderer;

import net.mcreator.callfromrapacosmo.client.model.ModelAncientAlien;
import net.mcreator.callfromrapacosmo.client.model.animations.AncientAlienAnimation;
import net.mcreator.callfromrapacosmo.entity.AncientAlienEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AncientAlienRenderer
extends MobRenderer<AncientAlienEntity, ModelAncientAlien<AncientAlienEntity>> {
    public AncientAlienRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAncientAlien.LAYER_LOCATION)), 0.3f);
    }

    public ResourceLocation getTextureLocation(AncientAlienEntity entity) {
        return ResourceLocation.parse((String)("call_from_rapa_cosmo:textures/entities/" + entity.getTexture() + ".png"));
    }

    private static final class AnimatedModel
    extends ModelAncientAlien<AncientAlienEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AncientAlienEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AncientAlienEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, AncientAlienAnimation.Chromatic, ageInTicks, 0.5f);
                this.animate(entity.animationState1, AncientAlienAnimation.Idle, ageInTicks, 1.0f);
                this.animateWalk(AncientAlienAnimation.Walk, limbSwing, limbSwingAmount, 3.0f, 2.0f);
                this.animate(entity.animationState3, AncientAlienAnimation.Attack, ageInTicks, 1.0f);
                this.animate(entity.animationState4, AncientAlienAnimation.Death, ageInTicks, 1.0f);
                this.animate(entity.animationState5, AncientAlienAnimation.Dance, ageInTicks, 1.2f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AncientAlienEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

