#version 120

uniform sampler2D DiffuseSampler;
varying vec2 texCoord;

void main() {
    float offset = 0.003; // tweak intensity

    float r = texture2D(DiffuseSampler, texCoord + vec2(-offset, 0.0)).r;
    float g = texture2D(DiffuseSampler, texCoord).g;
    float b = texture2D(DiffuseSampler, texCoord + vec2(offset, 0.0)).b;

    gl_FragColor = vec4(r, g, b, 1.0);
}
