/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.worlddownloader.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kuudraloremaster.worlddownloader.util.ContainerTracker;
import net.minecraft.class_1275;
import net.minecraft.class_155;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7522;
import net.minecraft.class_7924;

@Environment(value=EnvType.CLIENT)
public class ClientChunkSerializer {
    public static class_2487 serialize(class_638 world, class_2791 chunk) {
        int minSectionY;
        class_1923 chunkPos = chunk.method_12004();
        class_2487 chunkNbt = new class_2487();
        chunkNbt.method_10569("DataVersion", class_155.method_16673().comp_4026().comp_4038());
        chunkNbt.method_10569("xPos", chunkPos.field_9181);
        chunkNbt.method_10569("zPos", chunkPos.field_9180);
        chunkNbt.method_10544("InhabitedTime", chunk.method_12033());
        class_2378 chunkStatusRegistry = world.method_30349().method_30530(class_7924.field_41261);
        class_2960 statusId = chunkStatusRegistry.method_10221((Object)chunk.method_12009());
        chunkNbt.method_10582("Status", statusId != null ? statusId.toString() : "minecraft:full");
        class_2487 heightmaps = new class_2487();
        for (Map.Entry entry : chunk.method_12011()) {
            heightmaps.method_10566(((class_2902.class_2903)entry.getKey()).method_12605(), (class_2520)new class_2501(((class_2902)entry.getValue()).method_12598()));
        }
        chunkNbt.method_10566("Heightmaps", (class_2520)heightmaps);
        class_2499 sections = new class_2499();
        class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
        for (int y = minSectionY = world.method_32891(); y < world.method_31597(); ++y) {
            class_2826 section = chunk.method_12006()[world.method_31603(y)];
            if (section == null || section.method_38292()) continue;
            class_2487 sectionNbt = new class_2487();
            sectionNbt.method_10567("Y", (byte)y);
            class_2841 blockContainer = section.method_12265();
            sectionNbt.method_10566("block_states", (class_2520)ClientChunkSerializer.serializeBlockStates((class_2841<class_2680>)blockContainer, (class_7225.class_7874)world.method_30349()));
            class_7522 biomeContainer = section.method_38294();
            sectionNbt.method_10566("biomes", (class_2520)ClientChunkSerializer.serializeBiomes((class_7522<class_6880<class_1959>>)biomeContainer, (class_2378<class_1959>)biomeRegistry));
            sections.add((Object)sectionNbt);
        }
        chunkNbt.method_10566("sections", (class_2520)sections);
        class_2499 blockEntities = new class_2499();
        for (class_2338 pos : chunk.method_12021()) {
            class_2586 be = chunk.method_8321(pos);
            if (be == null) continue;
            try {
                class_2487 beNbt = ClientChunkSerializer.serializeBlockEntityWithItems(be, (class_7225.class_7874)world.method_30349());
                if (beNbt == null) continue;
                blockEntities.add((Object)beNbt);
            }
            catch (Exception e) {
                System.err.println("Failed to serialize block entity at " + String.valueOf(pos) + ": " + e.getMessage());
            }
        }
        chunkNbt.method_10566("block_entities", (class_2520)blockEntities);
        chunkNbt.method_10566("structures", (class_2520)new class_2487());
        chunkNbt.method_10556("isLightOn", chunk.method_12038());
        chunkNbt.method_10544("LastUpdate", System.currentTimeMillis() / 1000L);
        return chunkNbt;
    }

    private static class_2487 serializeBlockEntityWithItems(class_2586 blockEntity, class_7225.class_7874 registryLookup) {
        try {
            class_2487 beNbt = blockEntity.method_38242(registryLookup);
            beNbt = ContainerTracker.enhanceBlockEntityWithContainerData(blockEntity, beNbt);
            try {
                String[] beTypeId;
                class_2378 blockEntityTypeRegistry;
                class_310 client = class_310.method_1551();
                if (client.field_1687 != null && (blockEntityTypeRegistry = client.field_1687.method_30349().method_30530(class_7924.field_41255)) != null && (beTypeId = blockEntityTypeRegistry.method_10221((Object)blockEntity.method_11017())) != null) {
                    beNbt.method_10582("id", beTypeId.toString());
                }
            }
            catch (Exception e) {
                System.err.println("\u26a0 Failed to get block entity type ID: " + e.getMessage());
            }
            class_2338 pos = blockEntity.method_11016();
            beNbt.method_10569("x", pos.method_10263());
            beNbt.method_10569("y", pos.method_10264());
            beNbt.method_10569("z", pos.method_10260());
            try {
                class_2561 customName;
                class_1275 nameable;
                class_2487 additionalData = blockEntity.method_38242(registryLookup);
                if (additionalData.method_10545("Items") && !beNbt.method_10545("Items")) {
                    beNbt.method_10566("Items", additionalData.method_10580("Items"));
                    System.out.println("\u2705 Saved items for " + blockEntity.method_11017().toString() + " at " + String.valueOf(blockEntity.method_11016()));
                }
                for (String key : new String[]{"inventory", "Inventory", "items", "Contents"}) {
                    if (!additionalData.method_10545(key) || beNbt.method_10545(key)) continue;
                    beNbt.method_10566(key, additionalData.method_10580(key));
                    System.out.println("\u2705 Saved " + key + " for " + blockEntity.method_11017().toString());
                }
                if (additionalData.method_10545("CustomName") && !beNbt.method_10545("CustomName")) {
                    beNbt.method_10566("CustomName", additionalData.method_10580("CustomName"));
                } else if (additionalData.method_10545("custom_name") && !beNbt.method_10545("CustomName")) {
                    beNbt.method_10566("CustomName", additionalData.method_10580("custom_name"));
                }
                if (additionalData.method_10545("Lock")) {
                    beNbt.method_10566("Lock", additionalData.method_10580("Lock"));
                }
                if (blockEntity instanceof class_1275 && (nameable = (class_1275)blockEntity).method_16914() && (customName = nameable.method_5797()) != null) {
                    try {
                        String jsonName = customName.getString();
                        beNbt.method_10582("CustomName", jsonName);
                    }
                    catch (Exception e) {
                        String simpleName = "\"" + customName.getString() + "\"";
                        beNbt.method_10582("CustomName", simpleName);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("\u26a0 Failed to get additional NBT data for block entity: " + e.getMessage());
            }
            return beNbt;
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to serialize block entity with items: " + e.getMessage());
            try {
                return blockEntity.method_38242(registryLookup);
            }
            catch (Exception fallbackException) {
                System.err.println("\u274c Fallback serialization also failed: " + fallbackException.getMessage());
                return null;
            }
        }
    }

    private static class_2487 serializeBlockStates(class_2841<class_2680> container, class_7225.class_7874 registryLookup) {
        class_2487 blockStatesNbt = new class_2487();
        class_2378 blockRegistry = (class_2378)registryLookup.method_46762(class_7924.field_41254);
        ArrayList<class_2680> palette = new ArrayList<class_2680>();
        HashMap<class_2680, Integer> paletteIndices = new HashMap<class_2680, Integer>();
        ArrayList<Integer> rawData = new ArrayList<Integer>();
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int paletteIndex;
                    class_2680 state = (class_2680)container.method_12321(x, y, z);
                    if (!paletteIndices.containsKey(state)) {
                        paletteIndex = palette.size();
                        palette.add(state);
                        paletteIndices.put(state, paletteIndex);
                    } else {
                        paletteIndex = (Integer)paletteIndices.get(state);
                    }
                    rawData.add(paletteIndex);
                }
            }
        }
        int bitsPerEntry = Math.max(4, 32 - Integer.numberOfLeadingZeros(Math.max(1, palette.size() - 1)));
        long[] packedData = ClientChunkSerializer.packIntoLongArray(rawData, bitsPerEntry);
        class_2499 paletteNbt = new class_2499();
        for (class_2680 state : palette) {
            class_2487 stateNbt = new class_2487();
            class_2960 blockId = blockRegistry.method_10221((Object)state.method_26204());
            stateNbt.method_10582("Name", blockId.toString());
            if (!state.method_11656().isEmpty()) {
                class_2487 properties = new class_2487();
                state.method_11656().forEach((property, value) -> properties.method_10582(property.method_11899(), value.toString()));
                stateNbt.method_10566("Properties", (class_2520)properties);
            }
            paletteNbt.add((Object)stateNbt);
        }
        blockStatesNbt.method_10566("palette", (class_2520)paletteNbt);
        blockStatesNbt.method_10564("data", packedData);
        return blockStatesNbt;
    }

    private static class_2487 serializeBiomes(class_7522<class_6880<class_1959>> container, class_2378<class_1959> biomeRegistry) {
        class_2487 biomesNbt = new class_2487();
        ArrayList<class_6880> palette = new ArrayList<class_6880>();
        HashMap<class_6880, Integer> paletteIndices = new HashMap<class_6880, Integer>();
        ArrayList<Integer> rawData = new ArrayList<Integer>();
        for (int y = 0; y < 4; ++y) {
            for (int z = 0; z < 4; ++z) {
                for (int x = 0; x < 4; ++x) {
                    int paletteIndex;
                    class_6880 biome = (class_6880)container.method_12321(x, y, z);
                    if (!paletteIndices.containsKey(biome)) {
                        paletteIndex = palette.size();
                        palette.add(biome);
                        paletteIndices.put(biome, paletteIndex);
                    } else {
                        paletteIndex = (Integer)paletteIndices.get(biome);
                    }
                    rawData.add(paletteIndex);
                }
            }
        }
        int bitsPerEntry = Math.max(1, 32 - Integer.numberOfLeadingZeros(Math.max(1, palette.size() - 1)));
        long[] packedData = ClientChunkSerializer.packIntoLongArray(rawData, bitsPerEntry);
        class_2499 paletteNbt = new class_2499();
        for (class_6880 biomeEntry : palette) {
            biomeEntry.method_40230().ifPresent(key -> paletteNbt.add((Object)class_2519.method_23256((String)key.method_29177().toString())));
        }
        biomesNbt.method_10566("palette", (class_2520)paletteNbt);
        biomesNbt.method_10564("data", packedData);
        return biomesNbt;
    }

    private static long[] packIntoLongArray(List<Integer> data, int bitsPerEntry) {
        int valuesPerLong = 64 / bitsPerEntry;
        int arraySize = (data.size() + valuesPerLong - 1) / valuesPerLong;
        long[] result = new long[arraySize];
        long mask = (1L << bitsPerEntry) - 1L;
        for (int i = 0; i < data.size(); ++i) {
            int arrayIndex = i / valuesPerLong;
            int bitIndex = i % valuesPerLong * bitsPerEntry;
            int n = arrayIndex;
            result[n] = result[n] | ((long)data.get(i).intValue() & mask) << bitIndex;
        }
        return result;
    }
}

