/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.worlddownloader.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

@Environment(value=EnvType.CLIENT)
public class ContainerTracker {
    private static final Map<Integer, ContainerData> openContainers = new ConcurrentHashMap<Integer, ContainerData>();
    private static final Map<class_2338, class_2487> savedContainerData = new ConcurrentHashMap<class_2338, class_2487>();

    public static void onContainerOpened(int syncId, class_2561 name) {
        class_310 client = class_310.method_1551();
        class_239 class_2392 = client.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockHit = (class_3965)class_2392;
            class_2338 pos = blockHit.method_17777();
            openContainers.put(syncId, new ContainerData(pos, name));
            System.out.println("\ud83d\udce6 Container opened at " + String.valueOf(pos) + ": " + name.getString());
        }
    }

    public static void onSlotUpdate(int syncId, int slot, class_1799 stack) {
        ContainerData container = openContainers.get(syncId);
        if (container != null) {
            container.updateSlot(slot, stack);
        }
    }

    public static void onInventoryUpdate(int syncId, List<class_1799> contents) {
        ContainerData container = openContainers.get(syncId);
        if (container != null) {
            int totalSlots = contents.size();
            int containerSlots = ContainerTracker.determineContainerSlots(totalSlots);
            System.out.println("\ud83d\udd0d Processing container: " + totalSlots + " total slots, " + containerSlots + " container slots");
            if (containerSlots == 54) {
                ContainerTracker.handleDoubleChest(container, contents);
            } else {
                ContainerTracker.handleRegularContainer(container, contents, containerSlots);
            }
        }
    }

    private static void handleRegularContainer(ContainerData container, List<class_1799> contents, int containerSlots) {
        container.setContainerInventory(contents, containerSlots);
        class_2487 containerNbt = container.toNbt();
        savedContainerData.put(container.pos, containerNbt);
        int nonEmptySlots = ContainerTracker.countNonEmptySlots(contents, containerSlots);
        System.out.println("\u2705 Saved regular container at " + String.valueOf(container.pos) + " with " + nonEmptySlots + "/" + containerSlots + " filled slots");
    }

    private static void handleDoubleChest(ContainerData container, List<class_1799> contents) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            ContainerTracker.handleRegularContainer(container, contents, 54);
            return;
        }
        class_2338 pos = container.pos;
        class_2680 blockState = client.field_1687.method_8320(pos);
        if (!(blockState.method_26204() instanceof class_2281)) {
            ContainerTracker.handleRegularContainer(container, contents, 54);
            return;
        }
        try {
            class_2338 rightChestPos;
            class_2338 leftChestPos;
            class_2745 chestType = (class_2745)blockState.method_11654((class_2769)class_2281.field_10770);
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)class_2281.field_10768);
            if (chestType == class_2745.field_12569) {
                ContainerTracker.handleRegularContainer(container, contents, 27);
                return;
            }
            if (chestType == class_2745.field_12574) {
                leftChestPos = pos;
                rightChestPos = ContainerTracker.getAdjacentChestPos(pos, facing, true);
            } else {
                rightChestPos = pos;
                leftChestPos = ContainerTracker.getAdjacentChestPos(pos, facing, false);
            }
            List<class_1799> leftChestItems = contents.subList(0, Math.min(27, contents.size()));
            List<class_1799> rightChestItems = contents.subList(Math.min(27, contents.size()), Math.min(54, contents.size()));
            ContainerData leftContainer = new ContainerData(leftChestPos, container.name);
            leftContainer.setContainerInventory(leftChestItems, 27);
            leftContainer.setChestType(class_2745.field_12574, facing);
            class_2487 leftChestNbt = leftContainer.toNbt();
            savedContainerData.put(leftChestPos, leftChestNbt);
            ContainerData rightContainer = new ContainerData(rightChestPos, container.name);
            rightContainer.setContainerInventory(rightChestItems, 27);
            rightContainer.setChestType(class_2745.field_12571, facing);
            class_2487 rightChestNbt = rightContainer.toNbt();
            savedContainerData.put(rightChestPos, rightChestNbt);
            int leftNonEmpty = ContainerTracker.countNonEmptySlots(leftChestItems, 27);
            int rightNonEmpty = ContainerTracker.countNonEmptySlots(rightChestItems, 27);
            System.out.println("\u2705 Saved double chest:");
            System.out.println("   - Left chest at " + String.valueOf(leftChestPos) + " with " + leftNonEmpty + "/27 items");
            System.out.println("   - Right chest at " + String.valueOf(rightChestPos) + " with " + rightNonEmpty + "/27 items");
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to handle double chest, falling back to regular container: " + e.getMessage());
            ContainerTracker.handleRegularContainer(container, contents, 54);
        }
    }

    private static class_2338 getAdjacentChestPos(class_2338 pos, class_2350 facing, boolean isLeft) {
        class_2350 adjacentDirection = switch (facing) {
            case class_2350.field_11043 -> {
                if (isLeft) {
                    yield class_2350.field_11034;
                }
                yield class_2350.field_11039;
            }
            case class_2350.field_11035 -> {
                if (isLeft) {
                    yield class_2350.field_11039;
                }
                yield class_2350.field_11034;
            }
            case class_2350.field_11039 -> {
                if (isLeft) {
                    yield class_2350.field_11043;
                }
                yield class_2350.field_11035;
            }
            case class_2350.field_11034 -> {
                if (isLeft) {
                    yield class_2350.field_11035;
                }
                yield class_2350.field_11043;
            }
            default -> class_2350.field_11034;
        };
        return pos.method_10093(adjacentDirection);
    }

    private static int determineContainerSlots(int totalSlots) {
        return switch (totalSlots) {
            case 63 -> 27;
            case 90 -> 54;
            case 45 -> 9;
            case 41 -> 5;
            case 36 -> 36;
            default -> Math.max(0, totalSlots - 36);
        };
    }

    private static int countNonEmptySlots(List<class_1799> items, int maxSlots) {
        int count = 0;
        for (int i = 0; i < maxSlots && i < items.size(); ++i) {
            if (items.get(i).method_7960()) continue;
            ++count;
        }
        return count;
    }

    public static void onContainerClosed(int syncId) {
        ContainerData container = openContainers.remove(syncId);
        if (container != null) {
            System.out.println("\ud83d\udeaa Container closed at " + String.valueOf(container.pos));
        }
    }

    public static class_2487 getContainerData(class_2338 pos) {
        return savedContainerData.get(pos);
    }

    public static boolean hasContainerData(class_2338 pos) {
        return savedContainerData.containsKey(pos);
    }

    public static void clear() {
        openContainers.clear();
        savedContainerData.clear();
        System.out.println("\ud83d\uddd1\ufe0f Cleared all container data");
    }

    public static int getTotalSavedContainers() {
        return savedContainerData.size();
    }

    public static class_2487 enhanceBlockEntityWithContainerData(class_2586 blockEntity, class_2487 originalNbt) {
        class_2338 pos = blockEntity.method_11016();
        class_2487 containerData = ContainerTracker.getContainerData(pos);
        if (containerData != null) {
            if (containerData.method_10545("Items")) {
                originalNbt.method_10566("Items", containerData.method_10580("Items"));
                class_2499 items = (class_2499)containerData.method_10580("Items");
                System.out.println("\u2705 Enhanced block entity at " + String.valueOf(pos) + " with " + items.size() + " items");
            }
            if (containerData.method_10545("CustomName")) {
                originalNbt.method_10566("CustomName", containerData.method_10580("CustomName"));
            }
        }
        return originalNbt;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ContainerData {
        final class_2338 pos;
        final class_2561 name;
        final Map<Integer, class_1799> containerSlots = new ConcurrentHashMap<Integer, class_1799>();
        int containerSize = 27;
        private class_2745 chestType = null;
        private class_2350 facing = null;

        ContainerData(class_2338 pos, class_2561 name) {
            this.pos = pos;
            this.name = name;
        }

        void updateSlot(int slot, class_1799 stack) {
            if (!stack.method_7960()) {
                this.containerSlots.put(slot, stack.method_7972());
            } else {
                this.containerSlots.remove(slot);
            }
        }

        void setContainerInventory(List<class_1799> contents, int containerSlotCount) {
            this.containerSize = containerSlotCount;
            this.containerSlots.clear();
            for (int i = 0; i < containerSlotCount && i < contents.size(); ++i) {
                class_1799 stack = contents.get(i);
                if (stack.method_7960()) continue;
                this.containerSlots.put(i, stack.method_7972());
            }
        }

        void setChestType(class_2745 type, class_2350 facing) {
            this.chestType = type;
            this.facing = facing;
        }

        class_2487 toNbt() {
            class_2487 containerNbt = new class_2487();
            containerNbt.method_10569("x", this.pos.method_10263());
            containerNbt.method_10569("y", this.pos.method_10264());
            containerNbt.method_10569("z", this.pos.method_10260());
            containerNbt.method_10582("id", "minecraft:chest");
            if (this.name != null && !this.name.getString().isEmpty() && !this.name.getString().equals("Chest")) {
                try {
                    class_310 client = class_310.method_1551();
                    if (client.field_1687 != null) {
                        String jsonName = this.name.getString();
                        containerNbt.method_10582("CustomName", jsonName);
                    } else {
                        containerNbt.method_10582("CustomName", "\"" + this.name.getString() + "\"");
                    }
                }
                catch (Exception e) {
                    containerNbt.method_10582("CustomName", "\"" + this.name.getString() + "\"");
                }
            }
            class_2499 itemsList = new class_2499();
            for (Map.Entry<Integer, class_1799> entry : this.containerSlots.entrySet()) {
                class_1799 stack = entry.getValue();
                if (stack.method_7960()) continue;
                try {
                    class_2487 itemNbt = this.serializeItemStack(stack, entry.getKey());
                    if (itemNbt == null) continue;
                    itemsList.add((Object)itemNbt);
                }
                catch (Exception e) {
                    System.err.println("\u274c Failed to serialize item in slot " + String.valueOf(entry.getKey()) + ": " + e.getMessage());
                }
            }
            containerNbt.method_10566("Items", (class_2520)itemsList);
            return containerNbt;
        }

        private class_2487 serializeItemStack(class_1799 stack, int slot) {
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null) {
                return null;
            }
            try {
                class_2487 itemNbt = new class_2487();
                String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
                itemNbt.method_10582("id", itemId);
                itemNbt.method_10569("count", stack.method_7947());
                itemNbt.method_10567("Slot", (byte)slot);
                try {
                    class_2487 components;
                    class_2520 componentsNbt;
                    DataResult result = class_9326.field_49589.encodeStart((DynamicOps)client.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)stack.method_57380());
                    if (result.result().isPresent() && (componentsNbt = (class_2520)result.result().get()) instanceof class_2487 && !(components = (class_2487)componentsNbt).method_33133()) {
                        itemNbt.method_10566("components", (class_2520)components);
                    }
                }
                catch (Exception e) {
                    System.err.println("\u26a0 Failed to encode item components for " + itemId + ": " + e.getMessage());
                }
                return itemNbt;
            }
            catch (Exception e) {
                System.err.println("\u274c Item serialization failed: " + e.getMessage());
                class_2487 basicItem = new class_2487();
                basicItem.method_10582("id", class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
                basicItem.method_10569("count", stack.method_7947());
                basicItem.method_10567("Slot", (byte)slot);
                return basicItem;
            }
        }
    }
}

