/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.worlddownloader.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kuudraloremaster.worlddownloader.util.ChunkListener;
import net.kuudraloremaster.worlddownloader.util.ContainerTracker;
import net.kuudraloremaster.worlddownloader.util.EntityTracker;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.querz.mca.Chunk;
import net.querz.mca.MCAFile;
import net.querz.mca.MCAUtil;
import net.querz.nbt.io.NBTDeserializer;
import net.querz.nbt.io.NamedTag;
import net.querz.nbt.tag.CompoundTag;

@Environment(value=EnvType.CLIENT)
public class Exporter {
    public static void exportChunks() throws Exception {
        Path regionDir = Paths.get("downloaded_world", "region");
        if (!regionDir.toFile().exists() && !regionDir.toFile().mkdirs()) {
            throw new IOException("Failed to create region directory: " + String.valueOf(regionDir));
        }
        Map<class_1923, class_2487> allChunks = ChunkListener.getAll();
        if (allChunks.isEmpty()) {
            System.out.println("\u26a0 No chunks to export!");
            return;
        }
        HashMap<CallSite, MCAFile> regionFiles = new HashMap<CallSite, MCAFile>();
        for (Map.Entry<class_1923, class_2487> entry : allChunks.entrySet()) {
            class_1923 chunkPos = entry.getKey();
            class_2487 chunkNbt = entry.getValue();
            int chunkX = chunkPos.field_9181;
            int chunkZ = chunkPos.field_9180;
            int regionX = chunkX >> 5;
            int regionZ = chunkZ >> 5;
            int localChunkX = chunkX & 0x1F;
            int localChunkZ = chunkZ & 0x1F;
            String regionKey = regionX + "," + regionZ;
            Path regionFile = regionDir.resolve(String.format("r.%d.%d.mca", regionX, regionZ));
            MCAFile mcaFile = (MCAFile)regionFiles.get(regionKey);
            if (mcaFile == null) {
                if (regionFile.toFile().exists()) {
                    try {
                        mcaFile = MCAUtil.read(regionFile.toFile());
                    }
                    catch (Exception e) {
                        System.err.println("Failed to read existing region file " + String.valueOf(regionFile) + ", creating new one: " + e.getMessage());
                        mcaFile = new MCAFile(regionX, regionZ);
                    }
                } else {
                    mcaFile = new MCAFile(regionX, regionZ);
                }
                regionFiles.put((CallSite)((Object)regionKey), mcaFile);
            }
            try {
                List<class_2487> entities = EntityTracker.getEntitiesForChunk(chunkPos);
                if (!entities.isEmpty()) {
                    class_2499 entitiesList = new class_2499();
                    for (class_2487 entity : entities) {
                        entitiesList.add((Object)entity);
                    }
                    chunkNbt.method_10566("entities", (class_2520)entitiesList);
                    System.out.println("\u2705 Added " + entities.size() + " entities to chunk " + String.valueOf(chunkPos));
                }
                CompoundTag querzChunk = Exporter.convertToQuerz(chunkNbt);
                Chunk chunk = new Chunk(querzChunk);
                mcaFile.setChunk(localChunkX, localChunkZ, chunk);
                System.out.println(String.format("\u2705 Prepared chunk %d,%d with %d entities", chunkX, chunkZ, entities.size()));
            }
            catch (Exception e) {
                System.err.println("\u274c Failed to process chunk " + String.valueOf(chunkPos) + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        for (Map.Entry<Object, Object> entry : regionFiles.entrySet()) {
            String regionKey = (String)entry.getKey();
            MCAFile mcaFile = (MCAFile)entry.getValue();
            String[] coords = regionKey.split(",");
            int regionX = Integer.parseInt(coords[0]);
            int regionZ = Integer.parseInt(coords[1]);
            Path regionFile = regionDir.resolve(String.format("r.%d.%d.mca", regionX, regionZ));
            try {
                MCAUtil.write(mcaFile, regionFile.toFile());
                System.out.println("\u2705 Successfully wrote region file: " + String.valueOf(regionFile.getFileName()));
            }
            catch (Exception e) {
                System.err.println("\u274c Failed to write region file " + String.valueOf(regionFile) + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        int totalEntities = EntityTracker.getTotalTrackedEntities();
        int n = ContainerTracker.getTotalSavedContainers();
        System.out.println("\u2705 Exported " + allChunks.size() + " chunks with " + totalEntities + " entities and " + n + " containers to " + regionFiles.size() + " region files.");
    }

    public static CompoundTag convertToQuerz(class_2487 mcNbt) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            class_2507.method_55324((class_2520)mcNbt, (DataOutput)dos);
            dos.close();
            byte[] nbtData = bos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(nbtData);
            DataInputStream dis = new DataInputStream(bis);
            NamedTag namedTag = new NBTDeserializer(false).fromStream(dis);
            dis.close();
            return (CompoundTag)namedTag.getTag();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert NbtCompound to Querz CompoundTag", e);
        }
    }
}

