/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.querz.io.Serializer;
import net.querz.nbt.io.LittleEndianNBTOutputStream;
import net.querz.nbt.io.NBTOutput;
import net.querz.nbt.io.NBTOutputStream;
import net.querz.nbt.io.NamedTag;

@Environment(value=EnvType.CLIENT)
public class NBTSerializer
implements Serializer<NamedTag> {
    private boolean compressed;
    private boolean littleEndian;

    public NBTSerializer() {
        this(true);
    }

    public NBTSerializer(boolean compressed) {
        this.compressed = compressed;
    }

    public NBTSerializer(boolean compressed, boolean littleEndian) {
        this.compressed = compressed;
        this.littleEndian = littleEndian;
    }

    @Override
    public void toStream(NamedTag object, OutputStream out) throws IOException {
        OutputStream output = this.compressed ? new GZIPOutputStream(out, true) : out;
        DataOutput nbtOut = this.littleEndian ? new LittleEndianNBTOutputStream(output) : new NBTOutputStream(output);
        ((NBTOutput)((Object)nbtOut)).writeTag(object, 512);
        ((NBTOutput)((Object)nbtOut)).flush();
    }
}

