/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.querz.io.StringDeserializer;
import net.querz.nbt.io.SNBTParser;
import net.querz.nbt.tag.Tag;

@Environment(value=EnvType.CLIENT)
public class SNBTDeserializer
implements StringDeserializer<Tag<?>> {
    @Override
    public Tag<?> fromReader(Reader reader) throws IOException {
        return this.fromReader(reader, 512);
    }

    public Tag<?> fromReader(Reader reader, int maxDepth) throws IOException {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return new SNBTParser(bufferedReader.lines().collect(Collectors.joining())).parse(maxDepth);
    }
}

