/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.tag;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.querz.io.MaxDepthIO;
import net.querz.nbt.tag.ByteArrayTag;
import net.querz.nbt.tag.ByteTag;
import net.querz.nbt.tag.DoubleTag;
import net.querz.nbt.tag.FloatTag;
import net.querz.nbt.tag.IntArrayTag;
import net.querz.nbt.tag.IntTag;
import net.querz.nbt.tag.ListTag;
import net.querz.nbt.tag.LongArrayTag;
import net.querz.nbt.tag.LongTag;
import net.querz.nbt.tag.NonNullEntrySet;
import net.querz.nbt.tag.NumberTag;
import net.querz.nbt.tag.ShortTag;
import net.querz.nbt.tag.StringTag;
import net.querz.nbt.tag.Tag;

@Environment(value=EnvType.CLIENT)
public class CompoundTag
extends Tag<Map<String, Tag<?>>>
implements Iterable<Map.Entry<String, Tag<?>>>,
Comparable<CompoundTag>,
MaxDepthIO {
    public static final byte ID = 10;

    public CompoundTag() {
        super(CompoundTag.createEmptyValue());
    }

    @Override
    public byte getID() {
        return 10;
    }

    private static Map<String, Tag<?>> createEmptyValue() {
        return new HashMap(8);
    }

    public int size() {
        return ((Map)this.getValue()).size();
    }

    public Tag<?> remove(String key) {
        return (Tag)((Map)this.getValue()).remove(key);
    }

    public void clear() {
        ((Map)this.getValue()).clear();
    }

    public boolean containsKey(String key) {
        return ((Map)this.getValue()).containsKey(key);
    }

    public boolean containsValue(Tag<?> value) {
        return ((Map)this.getValue()).containsValue(value);
    }

    public Collection<Tag<?>> values() {
        return ((Map)this.getValue()).values();
    }

    public Set<String> keySet() {
        return ((Map)this.getValue()).keySet();
    }

    public Set<Map.Entry<String, Tag<?>>> entrySet() {
        return new NonNullEntrySet(((Map)this.getValue()).entrySet());
    }

    @Override
    public Iterator<Map.Entry<String, Tag<?>>> iterator() {
        return this.entrySet().iterator();
    }

    public void forEach(BiConsumer<String, Tag<?>> action) {
        ((Map)this.getValue()).forEach(action);
    }

    public <C extends Tag<?>> C get(String key, Class<C> type) {
        Tag t = (Tag)((Map)this.getValue()).get(key);
        return (C)(t != null ? (Tag)type.cast(t) : null);
    }

    public Tag<?> get(String key) {
        return (Tag)((Map)this.getValue()).get(key);
    }

    public NumberTag<?> getNumberTag(String key) {
        return (NumberTag)((Map)this.getValue()).get(key);
    }

    public Number getNumber(String key) {
        return (Number)this.getNumberTag(key).getValue();
    }

    public ByteTag getByteTag(String key) {
        return this.get(key, ByteTag.class);
    }

    public ShortTag getShortTag(String key) {
        return this.get(key, ShortTag.class);
    }

    public IntTag getIntTag(String key) {
        return this.get(key, IntTag.class);
    }

    public LongTag getLongTag(String key) {
        return this.get(key, LongTag.class);
    }

    public FloatTag getFloatTag(String key) {
        return this.get(key, FloatTag.class);
    }

    public DoubleTag getDoubleTag(String key) {
        return this.get(key, DoubleTag.class);
    }

    public StringTag getStringTag(String key) {
        return this.get(key, StringTag.class);
    }

    public ByteArrayTag getByteArrayTag(String key) {
        return this.get(key, ByteArrayTag.class);
    }

    public IntArrayTag getIntArrayTag(String key) {
        return this.get(key, IntArrayTag.class);
    }

    public LongArrayTag getLongArrayTag(String key) {
        return this.get(key, LongArrayTag.class);
    }

    public ListTag<?> getListTag(String key) {
        return this.get(key, ListTag.class);
    }

    public CompoundTag getCompoundTag(String key) {
        return this.get(key, CompoundTag.class);
    }

    public boolean getBoolean(String key) {
        Tag<?> t = this.get(key);
        return t instanceof ByteTag && ((ByteTag)t).asByte() > 0;
    }

    public byte getByte(String key) {
        ByteTag t = this.getByteTag(key);
        return t == null ? (byte)0 : t.asByte();
    }

    public short getShort(String key) {
        ShortTag t = this.getShortTag(key);
        return t == null ? (short)0 : t.asShort();
    }

    public int getInt(String key) {
        IntTag t = this.getIntTag(key);
        return t == null ? 0 : t.asInt();
    }

    public long getLong(String key) {
        LongTag t = this.getLongTag(key);
        return t == null ? 0L : t.asLong();
    }

    public float getFloat(String key) {
        FloatTag t = this.getFloatTag(key);
        return t == null ? 0.0f : t.asFloat();
    }

    public double getDouble(String key) {
        DoubleTag t = this.getDoubleTag(key);
        return t == null ? 0.0 : t.asDouble();
    }

    public String getString(String key) {
        StringTag t = this.getStringTag(key);
        return t == null ? "" : t.getValue();
    }

    public byte[] getByteArray(String key) {
        ByteArrayTag t = this.getByteArrayTag(key);
        return t == null ? ByteArrayTag.ZERO_VALUE : (byte[])t.getValue();
    }

    public int[] getIntArray(String key) {
        IntArrayTag t = this.getIntArrayTag(key);
        return t == null ? IntArrayTag.ZERO_VALUE : (int[])t.getValue();
    }

    public long[] getLongArray(String key) {
        LongArrayTag t = this.getLongArrayTag(key);
        return t == null ? LongArrayTag.ZERO_VALUE : (long[])t.getValue();
    }

    public Tag<?> put(String key, Tag<?> tag) {
        return ((Map)this.getValue()).put(Objects.requireNonNull(key), Objects.requireNonNull(tag));
    }

    public Tag<?> putBoolean(String key, boolean value) {
        return this.put(key, new ByteTag(value));
    }

    public Tag<?> putByte(String key, byte value) {
        return this.put(key, new ByteTag(value));
    }

    public Tag<?> putShort(String key, short value) {
        return this.put(key, new ShortTag(value));
    }

    public Tag<?> putInt(String key, int value) {
        return this.put(key, new IntTag(value));
    }

    public Tag<?> putLong(String key, long value) {
        return this.put(key, new LongTag(value));
    }

    public Tag<?> putFloat(String key, float value) {
        return this.put(key, new FloatTag(value));
    }

    public Tag<?> putDouble(String key, double value) {
        return this.put(key, new DoubleTag(value));
    }

    public Tag<?> putString(String key, String value) {
        return this.put(key, new StringTag(value));
    }

    public Tag<?> putByteArray(String key, byte[] value) {
        return this.put(key, new ByteArrayTag(value));
    }

    public Tag<?> putIntArray(String key, int[] value) {
        return this.put(key, new IntArrayTag(value));
    }

    public Tag<?> putLongArray(String key, long[] value) {
        return this.put(key, new LongArrayTag(value));
    }

    @Override
    public String valueToString(int maxDepth) {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry e : ((Map)this.getValue()).entrySet()) {
            sb.append(first ? "" : ",").append(CompoundTag.escapeString((String)e.getKey(), false)).append(":").append(((Tag)e.getValue()).toString(this.decrementMaxDepth(maxDepth)));
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (super.equals(other) && this.size() == ((CompoundTag)other).size()) {
            Map.Entry e;
            Tag<?> v;
            Iterator var2 = ((Map)this.getValue()).entrySet().iterator();
            do {
                if (var2.hasNext()) continue;
                return true;
            } while ((v = ((CompoundTag)other).get((String)(e = var2.next()).getKey())) != null && ((Tag)e.getValue()).equals(v));
            return false;
        }
        return false;
    }

    @Override
    public int compareTo(CompoundTag o) {
        return Integer.compare(this.size(), ((Map)o.getValue()).size());
    }

    @Override
    public CompoundTag clone() {
        CompoundTag copy = new CompoundTag();
        for (Map.Entry e : ((Map)this.getValue()).entrySet()) {
            copy.put((String)e.getKey(), (Tag<?>)((Tag)e.getValue()).clone());
        }
        return copy;
    }
}

