/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.worlddownloader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.kuudraloremaster.worlddownloader.util.Exporter;
import net.kuudraloremaster.worlddownloader.util.WorldExporter;
import net.minecraft.class_304;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class WorldDownloaderClient
implements ClientModInitializer {
    private static class_304 exportKey;

    public void onInitializeClient() {
        exportKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.worlddownloader.export", class_3675.class_307.field_1668, 79, "category.worlddownloader"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (exportKey.method_1436()) {
                Path worldFolder = Path.of("downloaded_world", new String[0]);
                Path regionDir = worldFolder.resolve("region");
                try {
                    Files.createDirectories(regionDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    System.err.println("\u274c Couldn't create world directory: " + e.getMessage());
                    return;
                }
                try {
                    Exporter.exportChunks();
                    WorldExporter.createLoadableWorld(worldFolder.toFile());
                    System.out.println("\u2705 World exported! Copy 'downloaded_world/' to '.minecraft/saves/'");
                }
                catch (Exception e) {
                    System.err.println("\u274c Failed to export world: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
    }
}

