/*
 * Decompiled with CFR 0.152.
 */
package net.querz.io;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.querz.io.Deserializer;

@Environment(value=EnvType.CLIENT)
public interface StringDeserializer<T>
extends Deserializer<T> {
    public T fromReader(Reader var1) throws IOException;

    default public T fromString(String s) throws IOException {
        return this.fromReader(new StringReader(s));
    }

    @Override
    default public T fromStream(InputStream stream) throws IOException {
        T var4;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            var4 = this.fromReader(reader);
        }
        return var4;
    }

    @Override
    default public T fromFile(File file) throws IOException {
        T var4;
        try (FileReader reader = new FileReader(file);){
            var4 = this.fromReader(reader);
        }
        return var4;
    }

    @Override
    default public T fromBytes(byte[] data) throws IOException {
        return this.fromReader(new StringReader(new String(data)));
    }
}

