/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.tag;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.querz.nbt.tag.Tag;

@Environment(value=EnvType.CLIENT)
public class StringTag
extends Tag<String>
implements Comparable<StringTag> {
    public static final byte ID = 8;
    public static final String ZERO_VALUE = "";

    public StringTag() {
        super(ZERO_VALUE);
    }

    public StringTag(String value) {
        super(value);
    }

    @Override
    public byte getID() {
        return 8;
    }

    @Override
    public String getValue() {
        return (String)super.getValue();
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
    }

    @Override
    public String valueToString(int maxDepth) {
        return StringTag.escapeString(this.getValue(), false);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.getValue().equals(((StringTag)other).getValue());
    }

    @Override
    public int compareTo(StringTag o) {
        return this.getValue().compareTo(o.getValue());
    }

    @Override
    public StringTag clone() {
        return new StringTag(this.getValue());
    }
}

