/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.worlddownloader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.kuudraloremaster.worlddownloader.util.ChunkListener;
import net.kuudraloremaster.worlddownloader.util.ContainerTracker;
import net.kuudraloremaster.worlddownloader.util.EntityTracker;
import net.kuudraloremaster.worlddownloader.util.Exporter;
import net.kuudraloremaster.worlddownloader.util.WorldExporter;
import net.minecraft.class_304;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class WorldDownloaderClient
implements ClientModInitializer {
    private static class_304 exportKey;
    private static class_304 clearKey;

    public void onInitializeClient() {
        exportKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.worlddownloader.export", class_3675.class_307.field_1668, 79, "category.worlddownloader"));
        clearKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.worlddownloader.clear", class_3675.class_307.field_1668, 76, "category.worlddownloader"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (exportKey.method_1436()) {
                Path worldFolder = Path.of("downloaded_world", new String[0]);
                Path regionDir = worldFolder.resolve("region");
                try {
                    Files.createDirectories(regionDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    System.err.println("\u274c Couldn't create world directory: " + e.getMessage());
                    return;
                }
                try {
                    int chunkCount = ChunkListener.getAll().size();
                    if (chunkCount == 0) {
                        System.out.println("\u26a0 No chunks to export! Walk around to load chunks first.");
                        return;
                    }
                    System.out.println("\ud83d\ude80 Starting export of " + chunkCount + " chunks...");
                    System.out.println("\ud83d\udcca Capturing entities...");
                    EntityTracker.captureAllEntities();
                    int entityCount = EntityTracker.getTotalTrackedEntities();
                    int containerCount = ContainerTracker.getTotalSavedContainers();
                    System.out.println("\ud83d\udce6 Found " + entityCount + " entities and " + containerCount + " containers");
                    Exporter.exportChunks();
                    WorldExporter.createLoadableWorld(worldFolder.toFile());
                    System.out.println("\u2705 World exported! Copy 'downloaded_world/' to '.minecraft/saves/'");
                    System.out.println("\ud83d\udcca Export Summary:");
                    System.out.println("   - Chunks: " + chunkCount);
                    System.out.println("   - Entities: " + entityCount);
                    System.out.println("   - Containers: " + containerCount);
                }
                catch (Exception e) {
                    System.err.println("\u274c Failed to export world: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            while (clearKey.method_1436()) {
                int chunkCount = ChunkListener.getAll().size();
                int entityCount = EntityTracker.getTotalTrackedEntities();
                int containerCount = ContainerTracker.getTotalSavedContainers();
                ChunkListener.clear();
                EntityTracker.clear();
                ContainerTracker.clear();
                System.out.println("\ud83d\uddd1\ufe0f Cleared cached data:");
                System.out.println("   - Chunks: " + chunkCount);
                System.out.println("   - Entities: " + entityCount);
                System.out.println("   - Containers: " + containerCount);
            }
        });
    }
}

