/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.worlddownloader.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kuudraloremaster.worlddownloader.util.ChunkListener;
import net.kuudraloremaster.worlddownloader.util.ClientChunkSerializer;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2672;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_634;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_634.class})
public abstract class ChunkDataMixin {
    @Inject(method={"onChunkData"}, at={@At(value="TAIL")})
    private void onChunkData(class_2672 packet, CallbackInfo ci) {
        class_634 handler = (class_634)this;
        class_638 world = handler.method_2890();
        if (world == null) {
            System.err.println("\u274c Client world is null during chunk data processing");
            return;
        }
        int x = packet.method_11523();
        int z = packet.method_11524();
        class_1923 pos = new class_1923(x, z);
        class_2818 loadedChunk = world.method_8497(x, z);
        if (loadedChunk != null) {
            try {
                class_2487 chunkNbt = ClientChunkSerializer.serialize(world, (class_2791)loadedChunk);
                ChunkListener.addChunkNbt(pos, chunkNbt);
                System.out.println("\u2705 Saved chunk NBT for: " + String.valueOf(pos));
            }
            catch (Exception e) {
                System.err.println("\u274c Failed to capture chunk NBT for " + String.valueOf(pos) + ": " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("\u26a0 Chunk at " + String.valueOf(pos) + " not fully loaded when onChunkData processed");
        }
    }
}

