/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.worlddownloader.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kuudraloremaster.worlddownloader.util.ContainerTracker;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2645;
import net.minecraft.class_2649;
import net.minecraft.class_2653;
import net.minecraft.class_310;
import net.minecraft.class_3944;
import net.minecraft.class_3965;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_634.class})
public class DebugContainerMixin {
    @Inject(method={"onOpenScreen"}, at={@At(value="HEAD")})
    private void debugOnOpenScreen(class_3944 packet, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        Object targetInfo = "unknown";
        class_239 class_2392 = client.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockHit = (class_3965)class_2392;
            class_2338 pos = blockHit.method_17777();
            if (client.field_1687 != null) {
                String blockName = client.field_1687.method_8320(pos).method_26204().toString();
                targetInfo = blockName + " at " + String.valueOf(pos);
            }
        }
        System.out.println("\ud83d\udd0d DEBUG: OpenScreen packet");
        System.out.println("   - syncId: " + packet.method_17592());
        System.out.println("   - name: " + packet.method_17594().getString());
        System.out.println("   - target: " + (String)targetInfo);
        ContainerTracker.onContainerOpened(packet.method_17592(), packet.method_17594());
    }

    @Inject(method={"onScreenHandlerSlotUpdate"}, at={@At(value="HEAD")})
    private void debugOnSlotUpdate(class_2653 packet, CallbackInfo ci) {
        String itemInfo = packet.method_11449().method_7960() ? "empty" : packet.method_11449().method_7909().toString() + " x" + packet.method_11449().method_7947();
        System.out.println("\ud83d\udd0d DEBUG: SlotUpdate packet - syncId: " + packet.method_11452() + ", slot: " + packet.method_11450() + ", item: " + itemInfo);
        ContainerTracker.onSlotUpdate(packet.method_11452(), packet.method_11450(), packet.method_11449());
    }

    @Inject(method={"onInventory"}, at={@At(value="HEAD")})
    private void debugOnInventory(class_2649 packet, CallbackInfo ci) {
        int i;
        int totalSlots = packet.comp_3839().size();
        int nonEmptySlots = 0;
        int containerSlots = 0;
        int playerSlots = 0;
        switch (totalSlots) {
            case 63: {
                containerSlots = 27;
                playerSlots = 36;
                break;
            }
            case 90: {
                containerSlots = 54;
                playerSlots = 36;
                break;
            }
            case 45: {
                containerSlots = 9;
                playerSlots = 36;
                break;
            }
            case 41: {
                containerSlots = 5;
                playerSlots = 36;
                break;
            }
            default: {
                containerSlots = Math.max(0, totalSlots - 36);
                playerSlots = 36;
            }
        }
        int containerNonEmpty = 0;
        int playerNonEmpty = 0;
        for (i = 0; i < packet.comp_3839().size(); ++i) {
            if (((class_1799)packet.comp_3839().get(i)).method_7960()) continue;
            ++nonEmptySlots;
            if (i < containerSlots) {
                ++containerNonEmpty;
                continue;
            }
            ++playerNonEmpty;
        }
        System.out.println("\ud83d\udd0d DEBUG: Inventory packet - syncId: " + packet.comp_3837());
        System.out.println("   - Total slots: " + totalSlots + " (" + containerSlots + " container + " + playerSlots + " player)");
        System.out.println("   - Non-empty: " + nonEmptySlots + " (" + containerNonEmpty + " container + " + playerNonEmpty + " player)");
        System.out.println("   - Container items (first 10):");
        for (i = 0; i < Math.min(10, containerSlots) && i < packet.comp_3839().size(); ++i) {
            if (((class_1799)packet.comp_3839().get(i)).method_7960()) continue;
            System.out.println("     [" + i + "] " + ((class_1799)packet.comp_3839().get(i)).method_7909().toString() + " x" + ((class_1799)packet.comp_3839().get(i)).method_7947());
        }
        ContainerTracker.onInventoryUpdate(packet.comp_3837(), packet.comp_3839());
    }

    @Inject(method={"onCloseScreen"}, at={@At(value="HEAD")})
    private void debugOnCloseScreen(class_2645 packet, CallbackInfo ci) {
        System.out.println("\ud83d\udd0d DEBUG: CloseScreen packet - syncId: " + packet.method_36148());
        ContainerTracker.onContainerClosed(packet.method_36148());
    }
}

