/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.worlddownloader.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.kuudraloremaster.worlddownloader.util.ChunkListener;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_9326;

@Environment(value=EnvType.CLIENT)
public class EntityTracker {
    private static final Map<class_1923, List<class_2487>> chunkEntities = new ConcurrentHashMap<class_1923, List<class_2487>>();

    public static void captureAllEntities() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            System.err.println("\u274c ClientWorld is null, cannot capture entities");
            return;
        }
        chunkEntities.clear();
        int totalEntities = 0;
        System.out.println("\ud83d\udd0d Starting entity capture...");
        for (class_1297 class_12972 : world.method_18112()) {
            if (class_12972 == null || class_12972 instanceof class_1657) continue;
            class_243 pos = class_12972.method_19538();
            int chunkX = (int)Math.floor(pos.field_1352) >> 4;
            int chunkZ = (int)Math.floor(pos.field_1350) >> 4;
            class_1923 chunkPos = new class_1923(chunkX, chunkZ);
            if (!ChunkListener.getAll().containsKey(chunkPos)) continue;
            try {
                class_2487 entityNbt = EntityTracker.serializeEntity(class_12972);
                if (entityNbt == null) continue;
                chunkEntities.computeIfAbsent(chunkPos, k -> new ArrayList()).add(entityNbt);
                ++totalEntities;
                String entityType = class_7923.field_41177.method_10221((Object)class_12972.method_5864()).toString();
                System.out.println("\ud83d\udcdd Captured " + entityType + " at " + String.format("%.1f,%.1f,%.1f", pos.field_1352, pos.field_1351, pos.field_1350) + " in chunk " + String.valueOf(chunkPos));
            }
            catch (Exception e) {
                System.err.println("\u274c Failed to serialize entity " + String.valueOf(class_12972.method_5864()) + " at " + String.valueOf(pos) + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        System.out.println("\u2705 Captured " + totalEntities + " entities across " + chunkEntities.size() + " chunks");
        for (Map.Entry entry : chunkEntities.entrySet()) {
            System.out.println("   Chunk " + String.valueOf(entry.getKey()) + ": " + ((List)entry.getValue()).size() + " entities");
        }
    }

    private static class_2487 serializeEntity(class_1297 entity) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return null;
        }
        try {
            class_2561 customName;
            class_2487 entityNbt = new class_2487();
            String entityTypeId = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
            entityNbt.method_10582("id", entityTypeId);
            class_243 pos = entity.method_19538();
            class_2499 posNbt = new class_2499();
            posNbt.add((Object)class_2489.method_23241((double)pos.field_1352));
            posNbt.add((Object)class_2489.method_23241((double)pos.field_1351));
            posNbt.add((Object)class_2489.method_23241((double)pos.field_1350));
            entityNbt.method_10566("Pos", (class_2520)posNbt);
            class_243 velocity = entity.method_18798();
            class_2499 motionNbt = new class_2499();
            motionNbt.add((Object)class_2489.method_23241((double)velocity.field_1352));
            motionNbt.add((Object)class_2489.method_23241((double)velocity.field_1351));
            motionNbt.add((Object)class_2489.method_23241((double)velocity.field_1350));
            entityNbt.method_10566("Motion", (class_2520)motionNbt);
            class_2499 rotationNbt = new class_2499();
            rotationNbt.add((Object)class_2494.method_23244((float)entity.method_36454()));
            rotationNbt.add((Object)class_2494.method_23244((float)entity.method_36455()));
            entityNbt.method_10566("Rotation", (class_2520)rotationNbt);
            UUID uuid = entity.method_5667();
            long most = uuid.getMostSignificantBits();
            long least = uuid.getLeastSignificantBits();
            int[] uuidArray = new int[]{(int)(most >>> 32), (int)most, (int)(least >>> 32), (int)least};
            entityNbt.method_10539("UUID", uuidArray);
            entityNbt.method_10575("Air", (short)entity.method_5669());
            entityNbt.method_10575("Fire", (short)entity.method_20802());
            entityNbt.method_10556("OnGround", entity.method_24828());
            entityNbt.method_10556("Invulnerable", entity.method_5655());
            entityNbt.method_10569("PortalCooldown", entity.method_51848());
            entityNbt.method_10556("Silent", entity.method_5701());
            entityNbt.method_10556("NoGravity", entity.method_5740());
            entityNbt.method_10556("Glowing", entity.method_5851());
            if (entity.method_16914() && (customName = entity.method_5797()) != null) {
                try {
                    String jsonName = customName.getString();
                    entityNbt.method_10582("CustomName", jsonName);
                    entityNbt.method_10556("CustomNameVisible", entity.method_5807());
                }
                catch (Exception e) {
                    entityNbt.method_10582("CustomName", "\"" + customName.getString() + "\"");
                    entityNbt.method_10556("CustomNameVisible", entity.method_5807());
                }
            }
            if (!entity.method_5752().isEmpty()) {
                class_2499 tags = new class_2499();
                for (String tag : entity.method_5752()) {
                    tags.add((Object)class_2519.method_23256((String)tag));
                }
                entityNbt.method_10566("Tags", (class_2520)tags);
            }
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                EntityTracker.addLivingEntityData(entityNbt, living);
            }
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                EntityTracker.addItemEntityData(entityNbt, itemEntity, client);
            }
            return entityNbt;
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to serialize entity " + String.valueOf(entity.method_5864()) + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static void addLivingEntityData(class_2487 entityNbt, class_1309 living) {
        int i;
        int i2;
        entityNbt.method_10548("Health", living.method_6032());
        entityNbt.method_10548("AbsorptionAmount", living.method_6067());
        entityNbt.method_10575("HurtTime", (short)living.field_6235);
        entityNbt.method_10569("HurtByTimestamp", living.method_6117());
        entityNbt.method_10575("DeathTime", (short)living.field_6213);
        class_2499 attributes = new class_2499();
        class_2487 maxHealthAttr = new class_2487();
        maxHealthAttr.method_10582("Name", "minecraft:generic.max_health");
        maxHealthAttr.method_10549("Base", (double)living.method_6063());
        attributes.add((Object)maxHealthAttr);
        entityNbt.method_10566("Attributes", (class_2520)attributes);
        class_2499 armorItems = new class_2499();
        class_2499 handItems = new class_2499();
        for (i2 = 0; i2 < 4; ++i2) {
            armorItems.add((Object)new class_2487());
        }
        for (i2 = 0; i2 < 2; ++i2) {
            handItems.add((Object)new class_2487());
        }
        entityNbt.method_10566("ArmorItems", (class_2520)armorItems);
        entityNbt.method_10566("HandItems", (class_2520)handItems);
        class_2499 armorDropChances = new class_2499();
        class_2499 handDropChances = new class_2499();
        for (i = 0; i < 4; ++i) {
            armorDropChances.add((Object)class_2494.method_23244((float)0.085f));
        }
        for (i = 0; i < 2; ++i) {
            handDropChances.add((Object)class_2494.method_23244((float)0.085f));
        }
        entityNbt.method_10566("ArmorDropChances", (class_2520)armorDropChances);
        entityNbt.method_10566("HandDropChances", (class_2520)handDropChances);
        if (living instanceof class_1308) {
            class_1308 mob = (class_1308)living;
            entityNbt.method_10556("CanPickUpLoot", mob.method_5936());
            entityNbt.method_10556("PersistenceRequired", mob.method_5947());
            entityNbt.method_10556("LeftHanded", mob.method_5961());
            entityNbt.method_10556("NoAI", mob.method_5987());
        }
        if (living instanceof class_1429) {
            class_1429 animal = (class_1429)living;
            entityNbt.method_10569("Age", animal.method_5618());
            entityNbt.method_10569("ForcedAge", animal.method_63605());
            entityNbt.method_10569("InLove", animal.method_29270());
            if (animal.method_6478() != null) {
                UUID lovingPlayerUuid = animal.method_6478().method_5667();
                long most = lovingPlayerUuid.getMostSignificantBits();
                long least = lovingPlayerUuid.getLeastSignificantBits();
                int[] lovingPlayerUuidArray = new int[]{(int)(most >>> 32), (int)most, (int)(least >>> 32), (int)least};
                entityNbt.method_10539("LoveCause", lovingPlayerUuidArray);
            }
        }
    }

    private static void addItemEntityData(class_2487 entityNbt, class_1542 itemEntity, class_310 client) {
        entityNbt.method_10575("Age", (short)itemEntity.method_6985());
        entityNbt.method_10575("PickupDelay", (short)10);
        class_1799 itemStack = itemEntity.method_6983();
        if (!itemStack.method_7960()) {
            try {
                class_2487 itemNbt = new class_2487();
                itemNbt.method_10582("id", class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString());
                itemNbt.method_10569("count", itemStack.method_7947());
                try {
                    class_2487 components;
                    class_2520 componentsNbt;
                    DataResult result = class_9326.field_49589.encodeStart((DynamicOps)client.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)itemStack.method_57380());
                    if (result.result().isPresent() && (componentsNbt = (class_2520)result.result().get()) instanceof class_2487 && !(components = (class_2487)componentsNbt).method_33133()) {
                        itemNbt.method_10566("components", (class_2520)components);
                    }
                }
                catch (Exception e) {
                    System.err.println("\u26a0 Failed to encode item components, using basic data only: " + e.getMessage());
                }
                entityNbt.method_10566("Item", (class_2520)itemNbt);
                System.out.println("   - Item: " + String.valueOf(class_7923.field_41178.method_10221((Object)itemStack.method_7909())) + " x" + itemStack.method_7947());
            }
            catch (Exception e) {
                System.err.println("\u274c Failed to serialize item stack for ItemEntity: " + e.getMessage());
                class_2487 basicItem = new class_2487();
                basicItem.method_10582("id", class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString());
                basicItem.method_10569("count", itemStack.method_7947());
                entityNbt.method_10566("Item", (class_2520)basicItem);
            }
        }
    }

    public static List<class_2487> getEntitiesForChunk(class_1923 chunkPos) {
        List entities = chunkEntities.getOrDefault(chunkPos, new ArrayList());
        if (!entities.isEmpty()) {
            System.out.println("\ud83d\udce6 Retrieved " + entities.size() + " entities for chunk " + String.valueOf(chunkPos));
        }
        return entities;
    }

    public static void clear() {
        int totalEntities = EntityTracker.getTotalTrackedEntities();
        chunkEntities.clear();
        System.out.println("\ud83d\uddd1\ufe0f Cleared " + totalEntities + " tracked entities");
    }

    public static int getTotalTrackedEntities() {
        return chunkEntities.values().stream().mapToInt(List::size).sum();
    }
}

