/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.worlddownloader.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;

@Environment(value=EnvType.CLIENT)
public class WorldExporter {
    public static void createLoadableWorld(File worldFolder) {
        try {
            if (!worldFolder.exists()) {
                worldFolder.mkdirs();
            }
            new File(worldFolder, "region").mkdirs();
            new File(worldFolder, "playerdata").mkdirs();
            new File(worldFolder, "advancements").mkdirs();
            new File(worldFolder, "stats").mkdirs();
            new File(worldFolder, "data").mkdirs();
            new File(worldFolder, "poi").mkdirs();
            new File(worldFolder, "entities").mkdirs();
            File sessionLock = new File(worldFolder, "session.lock");
            try (DataOutputStream out = new DataOutputStream(new FileOutputStream(sessionLock));){
                out.writeLong(System.currentTimeMillis());
            }
            class_2487 root = new class_2487();
            root.method_10569("DataVersion", 4325);
            class_2487 data = new class_2487();
            data.method_10582("LevelName", "Downloaded World");
            data.method_10544("RandomSeed", new Random().nextLong());
            data.method_10569("version", 19133);
            data.method_10556("initialized", true);
            data.method_10569("GameType", 1);
            data.method_10556("allowCommands", true);
            data.method_10556("hardcore", false);
            data.method_10569("Difficulty", 2);
            data.method_10556("DifficultyLocked", false);
            data.method_10582("generatorName", "minecraft:overworld");
            data.method_10569("generatorVersion", 1);
            data.method_10569("SpawnX", 0);
            data.method_10569("SpawnY", 80);
            data.method_10569("SpawnZ", 0);
            data.method_10548("SpawnAngle", 0.0f);
            data.method_10544("Time", 1000L);
            data.method_10544("DayTime", 1000L);
            data.method_10544("LastPlayed", System.currentTimeMillis());
            class_2487 worldBorder = new class_2487();
            worldBorder.method_10549("BorderCenterX", 0.0);
            worldBorder.method_10549("BorderCenterZ", 0.0);
            worldBorder.method_10549("BorderSize", 5.9999968E7);
            worldBorder.method_10549("BorderSizeLerpTarget", 5.9999968E7);
            worldBorder.method_10544("BorderSizeLerpTime", 0L);
            worldBorder.method_10549("BorderSafeZone", 5.0);
            worldBorder.method_10549("BorderDamagePerBlock", 0.2);
            worldBorder.method_10569("BorderWarningBlocks", 5);
            worldBorder.method_10569("BorderWarningTime", 15);
            data.method_10566("WorldBorder", (class_2520)worldBorder);
            class_2487 gameRules = new class_2487();
            gameRules.method_10582("keepInventory", "false");
            gameRules.method_10582("mobGriefing", "true");
            gameRules.method_10582("doFireTick", "true");
            gameRules.method_10582("doMobSpawning", "true");
            gameRules.method_10582("doMobLoot", "true");
            gameRules.method_10582("doTileDrops", "true");
            gameRules.method_10582("commandBlockOutput", "true");
            gameRules.method_10582("naturalRegeneration", "true");
            gameRules.method_10582("doDaylightCycle", "true");
            gameRules.method_10582("logAdminCommands", "true");
            gameRules.method_10582("showDeathMessages", "true");
            gameRules.method_10582("randomTickSpeed", "3");
            gameRules.method_10582("sendCommandFeedback", "true");
            data.method_10566("GameRules", (class_2520)gameRules);
            class_2487 player = new class_2487();
            player.method_10582("Dimension", "minecraft:overworld");
            class_2499 pos = new class_2499();
            pos.add((Object)class_2489.method_23241((double)0.0));
            pos.add((Object)class_2489.method_23241((double)80.0));
            pos.add((Object)class_2489.method_23241((double)0.0));
            player.method_10566("Pos", (class_2520)pos);
            class_2499 rotation = new class_2499();
            rotation.add((Object)class_2494.method_23244((float)0.0f));
            rotation.add((Object)class_2494.method_23244((float)0.0f));
            player.method_10566("Rotation", (class_2520)rotation);
            class_2499 motion = new class_2499();
            motion.add((Object)class_2489.method_23241((double)0.0));
            motion.add((Object)class_2489.method_23241((double)0.0));
            motion.add((Object)class_2489.method_23241((double)0.0));
            player.method_10566("Motion", (class_2520)motion);
            player.method_10548("Health", 20.0f);
            player.method_10569("playerGameType", 1);
            player.method_10556("OnGround", true);
            player.method_10569("Score", 0);
            player.method_10575("Air", (short)300);
            player.method_10575("Fire", (short)-20);
            player.method_10566("Inventory", (class_2520)new class_2499());
            player.method_10566("EnderItems", (class_2520)new class_2499());
            data.method_10566("Player", (class_2520)player);
            root.method_10566("Data", (class_2520)data);
            File levelDat = new File(worldFolder, "level.dat");
            try (FileOutputStream fos = new FileOutputStream(levelDat);){
                class_2507.method_10634((class_2487)root, (OutputStream)fos);
            }
            System.out.println("\u2705 World structure created at: " + worldFolder.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to create loadable world: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

