/*
 * Decompiled with CFR 0.152.
 */
package net.querz.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public interface Deserializer<T> {
    public T fromStream(InputStream var1) throws Exception;

    default public T fromFile(File file) throws Exception {
        T var4;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            var4 = this.fromStream(bis);
        }
        return var4;
    }

    default public T fromBytes(byte[] data) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        return this.fromStream(stream);
    }

    default public T fromResource(Class<?> clazz, String path) throws Exception {
        T var5;
        try (InputStream stream = clazz.getClassLoader().getResourceAsStream(path);){
            if (stream == null) {
                throw new IOException("resource \"" + path + "\" not found");
            }
            var5 = this.fromStream(stream);
        }
        return var5;
    }

    default public T fromURL(URL url) throws Exception {
        T var4;
        try (InputStream stream = url.openStream();){
            var4 = this.fromStream(stream);
        }
        return var4;
    }
}

