/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.backpack;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public abstract class IMaidBackpack {
    public abstract ResourceLocation getId();

    public abstract Item getItem();

    public abstract void onPutOn(ItemStack var1, PlayerEntity var2, EntityMaid var3);

    public ItemStack getTakeOffItemStack(ItemStack stack, @Nullable PlayerEntity player, EntityMaid maid) {
        return this.getItem().func_190903_i();
    }

    public abstract void onTakeOff(ItemStack var1, PlayerEntity var2, EntityMaid var3);

    public abstract void onSpawnTombstone(EntityMaid var1, EntityTombstone var2);

    public abstract INamedContainerProvider getGuiProvider(int var1);

    public boolean hasBackpackData() {
        return false;
    }

    @Nullable
    public IBackpackData getBackpackData(EntityMaid maid) {
        return null;
    }

    public abstract int getAvailableMaxContainerIndex();

    @OnlyIn(value=Dist.CLIENT)
    public abstract void offsetBackpackItem(MatrixStack var1);

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public abstract EntityModel<EntityMaid> getBackpackModel();

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public abstract ResourceLocation getBackpackTexture();

    protected final void dropAllItems(EntityMaid maid) {
        ItemsUtil.dropEntityItems((Entity)maid, (IItemHandler)maid.getMaidInv(), 6);
    }
}

