/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IAttackTask
extends IMaidTask {
    public static Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        return maid.func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g).flatMap(mobs -> mobs.stream().filter(maid::func_213336_c).filter(e -> maid.func_213389_a(e.func_233580_cy_())).findFirst());
    }

    public static boolean checkCanAttackEntity(LivingEntity target) {
        if (target instanceof PlayerEntity) {
            return false;
        }
        if (target instanceof TameableEntity) {
            TameableEntity tamableAnimal = (TameableEntity)target;
            return tamableAnimal.func_184753_b() == null;
        }
        return true;
    }

    default public boolean canAttack(EntityMaid maid, LivingEntity target) {
        LivingEntity maidLastHurtByMob;
        if (maid.func_70902_q() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)maid.func_70902_q();
            LivingEntity lastHurtByMob = player.func_70643_av();
            if (target.equals((Object)lastHurtByMob) && IAttackTask.checkCanAttackEntity(lastHurtByMob)) {
                return true;
            }
            LivingEntity lastHurtMob = player.func_110144_aD();
            if (target.equals((Object)lastHurtMob) && IAttackTask.checkCanAttackEntity(lastHurtMob)) {
                return true;
            }
        }
        if (target.equals((Object)(maidLastHurtByMob = maid.func_70643_av())) && IAttackTask.checkCanAttackEntity(maidLastHurtByMob)) {
            return true;
        }
        ResourceLocation key = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)target.func_200600_R());
        if (key != null && ((List)MaidConfig.MAID_ATTACK_IGNORE.get()).contains(key.toString())) {
            return false;
        }
        return target instanceof IMob;
    }

    default public boolean hasExtraAttack(EntityMaid maid, Entity target) {
        return false;
    }

    default public boolean doExtraAttack(EntityMaid maid, Entity target) {
        return false;
    }
}

