/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;

public interface IMaidTask {
    public ResourceLocation getUid();

    public ItemStack getIcon();

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid var1);

    public List<Pair<Integer, Task<? super EntityMaid>>> createBrainTasks(EntityMaid var1);

    default public boolean isEnable(EntityMaid maid) {
        return true;
    }

    default public TranslationTextComponent getName() {
        return new TranslationTextComponent(String.format("task.%s.%s", this.getUid().func_110624_b(), this.getUid().func_110623_a()));
    }

    default public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.emptyList();
    }

    default public List<String> getDescription(EntityMaid maid) {
        String key = String.format("task.%s.%s.desc", this.getUid().func_110624_b(), this.getUid().func_110623_a());
        return Lists.newArrayList((Object[])new String[]{key});
    }
}

