/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapability;
import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.inventory.AltarRecipeInventory;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockAltar
extends Block {
    public BlockAltar() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 2.0f).func_226896_b_());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityAltar();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return this.getAltar((IBlockReader)worldIn, pos).filter(altar -> handIn == Hand.MAIN_HAND).map(altar -> {
            if (player.func_225608_bj_() || player.func_184614_ca().func_190926_b()) {
                this.takeOutItem(worldIn, (TileEntityAltar)((Object)altar), player);
            } else {
                this.takeInOrCraft(worldIn, (TileEntityAltar)((Object)altar), player);
            }
            altar.refresh();
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }).orElse(super.func_225533_a_(state, worldIn, pos, player, handIn, hit));
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            this.getAltar((IBlockReader)worldIn, pos).ifPresent(altar -> {
                ItemStack stack = altar.handler.getStackInSlot(0);
                if (!stack.func_190926_b()) {
                    Block.func_180635_a((World)worldIn, (BlockPos)pos.func_177982_a(0, 1, 0), (ItemStack)stack);
                }
            });
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            this.getAltar((IBlockReader)world, pos).ifPresent(altar -> this.restoreStorageBlock(world, pos, altar.getBlockPosList()));
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            this.getAltar((IBlockReader)worldIn, pos).ifPresent(altar -> {
                this.restoreStorageBlock(worldIn, pos, altar.getBlockPosList());
                if (!player.func_184812_l_()) {
                    Block block = altar.getStorageState().func_177230_c();
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)block));
                }
            });
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getAltar(world, pos).map(altar -> new ItemStack((IItemProvider)altar.getStorageState().func_177230_c())).orElse(super.getPickBlock(state, target, world, pos, player));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        this.getAltar((IBlockReader)world, pos).ifPresent(altar -> Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, altar.getStorageState()));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target instanceof BlockRayTraceResult && world instanceof ClientWorld) {
            BlockRayTraceResult blockTarget = (BlockRayTraceResult)target;
            BlockPos pos = blockTarget.func_216350_a();
            ClientWorld clientWorld = (ClientWorld)world;
            this.getAltar((IBlockReader)world, pos).ifPresent(altar -> this.crack(clientWorld, pos, altar.getStorageState(), blockTarget.func_216354_b()));
        }
        return true;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getAltar((IBlockReader)world, pos).map(altar -> altar.getStorageState().func_215695_r()).orElse(super.getSoundType(state, world, pos, entity));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private void restoreStorageBlock(World worldIn, BlockPos currentPos, PosListData posList) {
        for (BlockPos storagePos : posList.getData()) {
            if (storagePos.equals((Object)currentPos)) continue;
            this.getAltar((IBlockReader)worldIn, storagePos).ifPresent(altar -> worldIn.func_180501_a(storagePos, altar.getStorageState(), 3));
        }
    }

    private void takeOutItem(World world, TileEntityAltar altar, PlayerEntity player) {
        if (altar.isCanPlaceItem() && !altar.handler.getStackInSlot(0).func_190926_b()) {
            ItemStack extractItem = altar.handler.extractItem(0, 1, false);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)extractItem);
            this.altarCraft(world, altar, player);
        }
    }

    private void takeInOrCraft(World world, TileEntityAltar altar, PlayerEntity playerIn) {
        if (altar.isCanPlaceItem() && altar.handler.getStackInSlot(0).func_190926_b()) {
            altar.handler.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)playerIn.func_184614_ca(), (int)1));
            if (!playerIn.func_184812_l_()) {
                playerIn.func_184614_ca().func_190918_g(1);
            }
            this.altarCraft(world, altar, playerIn);
        }
    }

    private void altarCraft(World world, TileEntityAltar altar, PlayerEntity playerIn) {
        AltarRecipeInventory inv = new AltarRecipeInventory();
        List<BlockPos> posList = altar.getCanPlaceItemPosList().getData();
        for (int i = 0; i < posList.size(); ++i) {
            TileEntity te = world.func_175625_s(posList.get(i));
            if (!(te instanceof TileEntityAltar)) continue;
            inv.func_70299_a(i, ((TileEntityAltar)te).getStorageItem());
        }
        if (inv.func_191420_l()) {
            return;
        }
        playerIn.getCapability(PowerCapabilityProvider.POWER_CAP, null).ifPresent(power -> world.func_199532_z().func_215371_a(InitRecipes.ALTAR_CRAFTING, (IInventory)inv, world).ifPresent(recipe -> this.spawnResultEntity(world, playerIn, (PowerCapability)power, (AltarRecipe)recipe, inv, altar)));
    }

    private Optional<TileEntityAltar> getAltar(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityAltar) {
            return Optional.of((TileEntityAltar)te);
        }
        return Optional.empty();
    }

    private void spawnResultEntity(World world, PlayerEntity playerIn, PowerCapability power, AltarRecipe altarRecipe, AltarRecipeInventory inventory, TileEntityAltar altar) {
        if (power.get() >= altarRecipe.getPowerCost()) {
            power.min(altarRecipe.getPowerCost());
            BlockPos centrePos = this.getCentrePos(altar.getBlockPosList(), altar.func_174877_v());
            if (world instanceof ServerWorld) {
                altarRecipe.spawnOutputEntity((ServerWorld)world, centrePos.func_177981_b(2), inventory);
            }
            this.removeAllAltarItem(world, altar);
            this.spawnParticleInCentre(world, centrePos);
            world.func_184133_a(null, centrePos, (SoundEvent)InitSounds.ALTAR_CRAFT.get(), SoundCategory.VOICE, 1.0f, 1.0f);
        } else if (!world.field_72995_K) {
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.altar.not_enough_power"), Util.field_240973_b_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void crack(ClientWorld world, BlockPos pos, BlockState state, Direction side) {
        if (state.func_185901_i() != BlockRenderType.INVISIBLE) {
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o();
            int posZ = pos.func_177952_p();
            AxisAlignedBB aabb = state.func_196954_c((IBlockReader)world, pos).func_197752_a();
            double x = (double)posX + this.RANDOM.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a - 0.2) + 0.1 + aabb.field_72340_a;
            double y = (double)posY + this.RANDOM.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b - 0.2) + 0.1 + aabb.field_72338_b;
            double z = (double)posZ + this.RANDOM.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c - 0.2) + 0.1 + aabb.field_72339_c;
            if (side == Direction.DOWN) {
                y = (double)posY + aabb.field_72338_b - 0.1;
            }
            if (side == Direction.UP) {
                y = (double)posY + aabb.field_72337_e + 0.1;
            }
            if (side == Direction.NORTH) {
                z = (double)posZ + aabb.field_72339_c - 0.1;
            }
            if (side == Direction.SOUTH) {
                z = (double)posZ + aabb.field_72334_f + 0.1;
            }
            if (side == Direction.WEST) {
                x = (double)posX + aabb.field_72340_a - 0.1;
            }
            if (side == Direction.EAST) {
                x = (double)posX + aabb.field_72336_d + 0.1;
            }
            DiggingParticle diggingParticle = new DiggingParticle(world, x, y, z, 0.0, 0.0, 0.0, state);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(diggingParticle.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
    }

    private BlockPos getCentrePos(PosListData posList, BlockPos posClick) {
        int x = 0;
        int y = posClick.func_177956_o() - 2;
        int z = 0;
        for (BlockPos pos : posList.getData()) {
            if (pos.func_177956_o() != y) continue;
            x += pos.func_177958_n();
            z += pos.func_177952_p();
        }
        return new BlockPos(x / 8, y, z / 8);
    }

    private void removeAllAltarItem(World world, TileEntityAltar altar) {
        for (BlockPos pos : altar.getCanPlaceItemPosList().getData()) {
            this.getAltar((IBlockReader)world, pos).ifPresent(te -> {
                te.handler.setStackInSlot(0, ItemStack.field_190927_a);
                te.refresh();
                this.spawnParticleInCentre(world, te.func_174877_v());
            });
        }
    }

    private void spawnParticleInCentre(World world, BlockPos centrePos) {
        boolean width = true;
        boolean height = true;
        for (int i = 0; i < 5; ++i) {
            double xSpeed = this.RANDOM.nextGaussian() * 0.02;
            double ySpeed = this.RANDOM.nextGaussian() * 0.02;
            double zSpeed = this.RANDOM.nextGaussian() * 0.02;
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, (double)((float)centrePos.func_177958_n() + this.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - xSpeed * 10.0, (double)((float)centrePos.func_177956_o() + this.RANDOM.nextFloat() * (float)height) - ySpeed * 10.0, (double)((float)centrePos.func_177952_p() + this.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - zSpeed * 10.0, xSpeed, ySpeed, zSpeed);
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)centrePos.func_177958_n() + this.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - xSpeed * 10.0, (double)((float)centrePos.func_177956_o() + this.RANDOM.nextFloat() * (float)height) - ySpeed * 10.0, (double)((float)centrePos.func_177952_p() + this.RANDOM.nextFloat() * (float)width * 2.0f - (float)width) - zSpeed * 10.0, xSpeed, ySpeed, zSpeed);
        }
    }
}

