/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockGarageKit
extends Block {
    public static final VoxelShape BLOCK_AABB = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final String ENTITY_INFO = "EntityInfo";

    public BlockGarageKit() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(1.0f, 2.0f).func_226896_b_());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityGarageKit();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        for (String modelId : CustomPackLoader.MAID_MODELS.getModelIdSet()) {
            ItemStack stack = new ItemStack((IItemProvider)InitBlocks.GARAGE_KIT.get());
            CompoundNBT data = stack.func_190925_c(ENTITY_INFO);
            data.func_74778_a("id", Objects.requireNonNull(((EntityType)InitEntities.MAID.get()).getRegistryName()).toString());
            data.func_74778_a("ModelId", modelId);
            items.add((Object)stack);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockGarageKit.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.getGarageKitFromWorld((IBlockReader)worldIn, pos));
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.getGarageKit((IBlockReader)worldIn, pos).ifPresent(te -> {
            Direction facing = Direction.SOUTH;
            if (placer != null) {
                facing = placer.func_174811_aO().func_176734_d();
            }
            te.setData(facing, ItemGarageKit.getMaidData(stack));
        });
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getGarageKitFromWorld(world, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!(worldIn instanceof ServerWorld) || !(stack.func_77973_b() instanceof SpawnEggItem)) {
            return ActionResultType.PASS;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityGarageKit)) {
            return ActionResultType.PASS;
        }
        EntityType type = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
        if (type.getRegistryName() == null) {
            return ActionResultType.PASS;
        }
        String id = type.getRegistryName().toString();
        CompoundNBT data = new CompoundNBT();
        data.func_74778_a("id", id);
        Entity entity = type.func_200721_a(worldIn);
        if (entity instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)entity;
            mobEntity.func_213386_a((IServerWorld)((ServerWorld)worldIn), worldIn.func_175649_E(pos), SpawnReason.SPAWN_EGG, null, data);
            mobEntity.func_213281_b(data);
        }
        TileEntityGarageKit garageKit = (TileEntityGarageKit)tile;
        garageKit.setData(garageKit.getFacing(), data);
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, Blocks.field_150435_aG.func_176223_P());
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target instanceof BlockRayTraceResult && world instanceof ClientWorld) {
            BlockRayTraceResult blockTarget = (BlockRayTraceResult)target;
            BlockPos pos = blockTarget.func_216350_a();
            ClientWorld clientWorld = (ClientWorld)world;
            this.crack(clientWorld, pos, Blocks.field_150435_aG.func_176223_P(), blockTarget.func_216354_b());
        }
        return true;
    }

    private ItemStack getGarageKitFromWorld(IBlockReader world, BlockPos pos) {
        ItemStack stack = new ItemStack((IItemProvider)InitBlocks.GARAGE_KIT.get());
        this.getGarageKit(world, pos).ifPresent(te -> stack.func_196082_o().func_218657_a(ENTITY_INFO, (INBT)te.getExtraData()));
        return stack;
    }

    private Optional<TileEntityGarageKit> getGarageKit(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGarageKit) {
            return Optional.of((TileEntityGarageKit)te);
        }
        return Optional.empty();
    }

    @Nullable
    public EntityType<?> getType(@Nullable CompoundNBT nbt) {
        CompoundNBT compoundnbt;
        if (nbt != null && nbt.func_150297_b("EntityTag", 10) && (compoundnbt = nbt.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return EntityType.func_220327_a((String)compoundnbt.func_74779_i("id")).orElse(null);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void crack(ClientWorld world, BlockPos pos, BlockState state, Direction side) {
        if (state.func_185901_i() != BlockRenderType.INVISIBLE) {
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o();
            int posZ = pos.func_177952_p();
            AxisAlignedBB aabb = state.func_196954_c((IBlockReader)world, pos).func_197752_a();
            double x = (double)posX + this.RANDOM.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a - 0.2) + 0.1 + aabb.field_72340_a;
            double y = (double)posY + this.RANDOM.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b - 0.2) + 0.1 + aabb.field_72338_b;
            double z = (double)posZ + this.RANDOM.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c - 0.2) + 0.1 + aabb.field_72339_c;
            if (side == Direction.DOWN) {
                y = (double)posY + aabb.field_72338_b - 0.1;
            }
            if (side == Direction.UP) {
                y = (double)posY + aabb.field_72337_e + 0.1;
            }
            if (side == Direction.NORTH) {
                z = (double)posZ + aabb.field_72339_c - 0.1;
            }
            if (side == Direction.SOUTH) {
                z = (double)posZ + aabb.field_72334_f + 0.1;
            }
            if (side == Direction.WEST) {
                x = (double)posX + aabb.field_72340_a - 0.1;
            }
            if (side == Direction.EAST) {
                x = (double)posX + aabb.field_72336_d + 0.1;
            }
            DiggingParticle diggingParticle = new DiggingParticle(world, x, y, z, 0.0, 0.0, 0.0, state);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(diggingParticle.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BLOCK_AABB;
    }
}

