/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.block.BlockJoy;
import com.github.tartaricacid.touhoulittlemaid.block.properties.GomokuPart;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.ChessDataToClientMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockGomoku
extends BlockJoy {
    public static final EnumProperty<GomokuPart> PART = EnumProperty.func_177709_a((String)"part", GomokuPart.class);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final VoxelShape LEFT_UP = Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape LEFT_UP_WITH_BOX = VoxelShapes.func_197872_a((VoxelShape)LEFT_UP, (VoxelShape)Block.func_208617_a((double)11.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)7.0));
    public static final VoxelShape UP = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape RIGHT_UP = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)16.0);
    public static final VoxelShape RIGHT_UP_WITH_BOX = VoxelShapes.func_197872_a((VoxelShape)RIGHT_UP, (VoxelShape)Block.func_208617_a((double)9.0, (double)0.0, (double)11.0, (double)14.0, (double)4.0, (double)16.0));
    public static final VoxelShape LEFT_CENTER = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape CENTER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape RIGHT_CENTER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)16.0);
    public static final VoxelShape LEFT_DOWN = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    public static final VoxelShape LEFT_DOWN_WITH_BOX = VoxelShapes.func_197872_a((VoxelShape)LEFT_DOWN, (VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)7.0, (double)4.0, (double)5.0));
    public static final VoxelShape DOWN = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    public static final VoxelShape RIGHT_DOWN = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)8.0);
    public static final VoxelShape RIGHT_DOWN_WITH_BOX = VoxelShapes.func_197872_a((VoxelShape)RIGHT_DOWN, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)9.0, (double)5.0, (double)4.0, (double)14.0));

    public BlockGomoku() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 3.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)((Object)GomokuPart.CENTER))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static void handleGomokuRemove(World world, BlockPos pos, BlockState state) {
        if (!world.field_72995_K) {
            GomokuPart part = (GomokuPart)((Object)state.func_177229_b(PART));
            BlockPos centerPos = pos.func_177973_b(new Vector3i(part.getPosX(), 0, part.getPosY()));
            TileEntity te = world.func_175625_s(centerPos);
            BlockGomoku.func_180635_a((World)world, (BlockPos)centerPos, (ItemStack)((Item)InitItems.GOMOKU.get()).func_190903_i());
            if (te instanceof TileEntityGomoku) {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        world.func_175656_a(centerPos.func_177982_a(i, 0, j), Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
    }

    @Nullable
    private static int[] getChessPos(double x, double y, GomokuPart part) {
        switch (part) {
            case LEFT_UP: {
                return BlockGomoku.getData(x, y, 0.505, 0.505, 0.54, 0.54, 0, 0);
            }
            case UP: {
                return BlockGomoku.getData(x, y, 0.037, 0.505, 0.08, 0.54, 4, 0);
            }
            case RIGHT_UP: {
                return BlockGomoku.getData(x, y, -0.037, 0.505, -0.01, 0.54, 11, 0);
            }
            case LEFT_CENTER: {
                return BlockGomoku.getData(x, y, 0.505, 0.037, 0.54, 0.07, 0, 4);
            }
            case CENTER: {
                return BlockGomoku.getData(x, y, 0.037, 0.037, 0.08, 0.07, 4, 4);
            }
            case RIGHT_CENTER: {
                return BlockGomoku.getData(x, y, -0.037, 0.037, -0.01, 0.07, 11, 4);
            }
            case LEFT_DOWN: {
                return BlockGomoku.getData(x, y, 0.505, 0.0, 0.54, 0.0, 0, 11);
            }
            case DOWN: {
                return BlockGomoku.getData(x, y, 0.037, 0.0, 0.08, 0.0, 4, 11);
            }
            case RIGHT_DOWN: {
                return BlockGomoku.getData(x, y, -0.037, 0.0, -0.01, 0.0, 11, 11);
            }
        }
        return null;
    }

    private static boolean isClickChessBox(double x, double y, GomokuPart part, Direction direction) {
        if (direction.func_176740_k() == Direction.Axis.Z) {
            if (part == GomokuPart.RIGHT_UP) {
                return 0.5625 <= x && x <= 0.875 && 0.6875 <= y && y <= 1.0;
            }
            if (part == GomokuPart.LEFT_DOWN) {
                return 0.125 <= x && x <= 0.4375 && 0.0 <= y && y <= 0.3125;
            }
        }
        if (direction.func_176740_k() == Direction.Axis.X) {
            if (part == GomokuPart.LEFT_UP) {
                return 0.6875 <= x && x <= 1.0 && 0.125 <= y && y <= 0.4375;
            }
            if (part == GomokuPart.RIGHT_DOWN) {
                return 0.0 <= x && x <= 0.3125 && 0.5625 <= y && y <= 0.875;
            }
        }
        return false;
    }

    @Nullable
    private static int[] getData(double x, double y, double xOffset, double yOffset, double xStartOffset, double yStartOffset, int xIndexOffset, int yIndexOffset) {
        boolean checkClick;
        int xIndex = (int)((x - xOffset) / 0.1316);
        int yIndex = (int)((y - yOffset) / 0.1316);
        double xStart = xStartOffset + (double)xIndex * 0.1316;
        double xEnd = xStart + 0.07;
        double yStart = yStartOffset + (double)yIndex * 0.1316;
        double yEnd = yStart + 0.07;
        boolean checkIndex = 0 <= (xIndex += xIndexOffset) && xIndex <= 14 && 0 <= (yIndex += yIndexOffset) && yIndex <= 14;
        boolean bl = checkClick = xStart < x && x < xEnd && yStart < y && y < yEnd;
        if (checkIndex && checkClick) {
            return new int[]{xIndex, yIndex};
        }
        return null;
    }

    @Override
    protected Vector3d sitPosition() {
        return Vector3d.field_186680_a;
    }

    @Override
    protected String getTypeName() {
        return Type.GOMOKU.getTypeName();
    }

    @Override
    protected int sitYRot() {
        return 0;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockGomoku.handleGomokuRemove(world, pos, state);
        super.func_176208_a(world, pos, state, player);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        BlockGomoku.handleGomokuRemove(world, pos, state);
        super.onBlockExploded(state, world, pos, explosion);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos centerPos = context.func_195995_a();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = centerPos.func_177982_a(i, 0, j);
                if (context.func_195991_k().func_180495_p(searchPos).func_196953_a(context)) continue;
                return null;
            }
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = pos.func_177982_a(i, 0, j);
                GomokuPart part = GomokuPart.getPartByPos(i, j);
                if (part == null || part.isCenter()) continue;
                worldIn.func_180501_a(searchPos, (BlockState)state.func_206870_a(PART, (Comparable)((Object)part)), 3);
            }
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (level instanceof ServerWorld && hand == Hand.MAIN_HAND && player.func_184614_ca().func_190926_b()) {
            ServerWorld serverLevel = (ServerWorld)level;
            GomokuPart part = (GomokuPart)((Object)state.func_177229_b(PART));
            BlockPos centerPos = pos.func_177973_b(new Vector3i(part.getPosX(), 0, part.getPosY()));
            TileEntity te = level.func_175625_s(centerPos);
            if (!(te instanceof TileEntityGomoku)) {
                return ActionResultType.FAIL;
            }
            TileEntityGomoku gomoku = (TileEntityGomoku)te;
            Vector3d location = hit.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            if (BlockGomoku.isClickChessBox(location.field_72450_a, location.field_72449_c, part, facing)) {
                level.func_184133_a(null, centerPos, (SoundEvent)InitSounds.GOMOKU_RESET.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                gomoku.reset();
                gomoku.refresh();
                return ActionResultType.SUCCESS;
            }
            Entity sitEntity = serverLevel.func_217461_a(gomoku.getSitId());
            if (sitEntity == null || !sitEntity.func_70089_S() || sitEntity.func_184188_bt().isEmpty() || !(sitEntity.func_184188_bt().get(0) instanceof EntityMaid)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.gomoku.no_maid"), Util.field_240973_b_);
                return ActionResultType.FAIL;
            }
            EntityMaid maid = (EntityMaid)((Object)sitEntity.func_184188_bt().get(0));
            if (((Boolean)MaidConfig.MAID_GOMOKU_OWNER_LIMIT.get()).booleanValue() && !maid.func_152114_e((LivingEntity)player)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.gomoku.not_owner"), Util.field_240973_b_);
                return ActionResultType.FAIL;
            }
            if (!gomoku.isPlayerTurn()) {
                return ActionResultType.FAIL;
            }
            int[][] chessData = gomoku.getChessData();
            int[] clickPos = BlockGomoku.getChessPos(location.field_72450_a, location.field_72449_c, part);
            if (clickPos == null) {
                return ActionResultType.FAIL;
            }
            Point playerPoint = new Point(clickPos[0], clickPos[1], 1);
            if (gomoku.isInProgress() && chessData[playerPoint.x][playerPoint.y] == 0) {
                gomoku.setChessData(playerPoint.x, playerPoint.y, playerPoint.type);
                Statue statue = MaidGomokuAI.getStatue(chessData, playerPoint);
                if (statue == Statue.WIN && maid.func_152114_e((LivingEntity)player)) {
                    maid.getFavorabilityManager().apply(Type.GOMOKU_WIN);
                    int rankBefore = MaidGomokuAI.getRank(maid);
                    MaidGomokuAI.addMaidCount(maid);
                    int rankAfter = MaidGomokuAI.getRank(maid);
                    if (rankBefore < rankAfter) {
                        NetworkHandler.sendToClientPlayer(new SpawnParticleMessage(maid.func_145782_y(), SpawnParticleMessage.Type.RANK_UP), player);
                    }
                }
                gomoku.setInProgress(statue == Statue.IN_PROGRESS);
                level.func_184133_a(null, pos, (SoundEvent)InitSounds.GOMOKU.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + level.field_73012_v.nextFloat() * 0.4f);
                if (gomoku.isInProgress()) {
                    gomoku.setPlayerTurn(false);
                    NetworkHandler.sendToClientPlayer(new ChessDataToClientMessage(centerPos, chessData, playerPoint, MaidGomokuAI.getMaidCount(maid)), player);
                }
                gomoku.refresh();
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public void startMaidSit(EntityMaid maid, BlockState state, World worldIn, BlockPos pos) {
        if (worldIn instanceof ServerWorld && worldIn.func_175625_s(pos) instanceof TileEntityJoy) {
            ServerWorld serverLevel = (ServerWorld)worldIn;
            TileEntityJoy joy = (TileEntityJoy)worldIn.func_175625_s(pos);
            Entity oldSitEntity = serverLevel.func_217461_a(joy.getSitId());
            if (oldSitEntity != null && oldSitEntity.func_70089_S()) {
                return;
            }
            Direction face = ((Direction)state.func_177229_b((Property)FACING)).func_176746_e();
            Vector3d position = new Vector3d(0.5 + (double)face.func_82601_c() * 1.5, 0.1, 0.5 + (double)face.func_82599_e() * 1.5);
            Vector3d sitPos = new Vector3d((double)pos.func_177958_n() + position.field_72450_a, (double)pos.func_177956_o() + position.field_72448_b, (double)pos.func_177952_p() + position.field_72449_c);
            EntitySit newSitEntity = new EntitySit(worldIn, sitPos, this.getTypeName());
            newSitEntity.field_70177_z = face.func_176734_d().func_185119_l() + (float)this.sitYRot();
            worldIn.func_217376_c((Entity)newSitEntity);
            joy.setSitId(newSitEntity.func_110124_au());
            joy.func_70296_d();
            maid.func_184220_m(newSitEntity);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, FACING});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (((GomokuPart)((Object)state.func_177229_b(PART))).isCenter()) {
            return new TileEntityGomoku();
        }
        return null;
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((GomokuPart)((Object)state.func_177229_b(PART))) {
            case LEFT_UP: {
                if (((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X) {
                    return LEFT_UP_WITH_BOX;
                }
                return LEFT_UP;
            }
            case UP: {
                return UP;
            }
            case RIGHT_UP: {
                if (((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.Z) {
                    return RIGHT_UP_WITH_BOX;
                }
                return RIGHT_UP;
            }
            case LEFT_CENTER: {
                return LEFT_CENTER;
            }
            case RIGHT_CENTER: {
                return RIGHT_CENTER;
            }
            case LEFT_DOWN: {
                if (((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.Z) {
                    return LEFT_DOWN_WITH_BOX;
                }
                return LEFT_DOWN;
            }
            case DOWN: {
                return DOWN;
            }
            case RIGHT_DOWN: {
                if (((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X) {
                    return RIGHT_DOWN_WITH_BOX;
                }
                return RIGHT_DOWN;
            }
        }
        return CENTER;
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

