/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class BlockJoy
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    protected BlockJoy(AbstractBlock.Properties properties) {
        super(properties);
    }

    public BlockJoy() {
        this(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 3.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected abstract Vector3d sitPosition();

    protected abstract String getTypeName();

    protected abstract int sitYRot();

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (worldIn instanceof ServerWorld && playerIn.func_184586_b(hand).func_190926_b() && worldIn.func_175625_s(pos) instanceof TileEntityJoy) {
            ServerWorld serverLevel = (ServerWorld)worldIn;
            TileEntityJoy joy = (TileEntityJoy)worldIn.func_175625_s(pos);
            Entity oldSitEntity = serverLevel.func_217461_a(joy.getSitId());
            if (oldSitEntity != null && oldSitEntity.func_70089_S()) {
                return super.func_225533_a_(state, worldIn, pos, playerIn, hand, hit);
            }
            Vector3d sitPos = new Vector3d((double)pos.func_177958_n() + this.sitPosition().field_72450_a, (double)pos.func_177956_o() + this.sitPosition().field_72448_b, (double)pos.func_177952_p() + this.sitPosition().field_72449_c);
            EntitySit newSitEntity = new EntitySit(worldIn, sitPos, this.getTypeName());
            newSitEntity.field_70177_z = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d().func_185119_l() + (float)this.sitYRot();
            worldIn.func_217376_c((Entity)newSitEntity);
            joy.setSitId(newSitEntity.func_110124_au());
            joy.func_70296_d();
            playerIn.func_184220_m((Entity)newSitEntity);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, playerIn, hand, hit);
    }

    public void startMaidSit(EntityMaid maid, BlockState state, World worldIn, BlockPos pos) {
        if (worldIn instanceof ServerWorld && worldIn.func_175625_s(pos) instanceof TileEntityJoy) {
            ServerWorld serverLevel = (ServerWorld)worldIn;
            TileEntityJoy joy = (TileEntityJoy)worldIn.func_175625_s(pos);
            Entity oldSitEntity = serverLevel.func_217461_a(joy.getSitId());
            if (oldSitEntity != null && oldSitEntity.func_70089_S()) {
                return;
            }
            Vector3d sitPos = new Vector3d((double)pos.func_177958_n() + this.sitPosition().field_72450_a, (double)pos.func_177956_o() + this.sitPosition().field_72448_b, (double)pos.func_177952_p() + this.sitPosition().field_72449_c);
            EntitySit newSitEntity = new EntitySit(worldIn, sitPos, this.getTypeName());
            newSitEntity.field_70177_z = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d().func_185119_l() + (float)this.sitYRot();
            worldIn.func_217376_c((Entity)newSitEntity);
            joy.setSitId(newSitEntity.func_110124_au());
            joy.func_70296_d();
            maid.func_184220_m(newSitEntity);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityJoy joy;
        ServerWorld serverLevel;
        Entity entity;
        TileEntity blockEntity = worldIn.func_175625_s(pos);
        if (blockEntity instanceof TileEntityJoy && worldIn instanceof ServerWorld && (entity = (serverLevel = (ServerWorld)worldIn).func_217461_a((joy = (TileEntityJoy)blockEntity).getSitId())) instanceof EntitySit) {
            entity.func_70106_y();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

