/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenBeaconGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockMaidBeacon
extends Block {
    public static final EnumProperty<Position> POSITION = EnumProperty.func_177709_a((String)"position", Position.class);
    private static final VoxelShape UP_AABB = Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape DOWN_AABB = Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)26.0, (double)9.5);

    public BlockMaidBeacon() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 2.0f).func_226896_b_().func_235838_a_(s -> s.func_177229_b(POSITION) == Position.DOWN ? 0 : 15));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(POSITION, (Comparable)((Object)Position.DOWN)));
    }

    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(POSITION) != Position.DOWN;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityMaidBeacon();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityMaidBeacon) {
            if (!worldIn.field_72995_K) {
                NetworkHandler.sendToClientPlayer(new OpenBeaconGuiMessage(pos), player);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Position position = (Position)((Object)state.func_177229_b(POSITION));
        return position == Position.DOWN ? DOWN_AABB : UP_AABB;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176740_k() == Direction.Axis.Y) {
            Position position = (Position)((Object)stateIn.func_177229_b(POSITION));
            if (!(position != Position.DOWN || facing != Direction.UP || facingState.func_203425_a((Block)this) && facingState.func_177229_b(POSITION) != Position.DOWN)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            if (!(position == Position.DOWN || facing != Direction.DOWN || facingState.func_203425_a((Block)this) && facingState.func_177229_b(POSITION) != Position.UP_W_E && facingState.func_177229_b(POSITION) != Position.UP_N_S)) {
                return Blocks.field_150350_a.func_176223_P();
            }
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos belowPos;
        BlockState belowState;
        Position position;
        if (!worldIn.field_72995_K && player.func_184812_l_() && (position = (Position)((Object)state.func_177229_b(POSITION))) != Position.DOWN && (belowState = worldIn.func_180495_p(belowPos = pos.func_177977_b())).func_203425_a((Block)this) && belowState.func_177229_b(POSITION) == Position.DOWN) {
            worldIn.func_180501_a(belowPos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, belowPos, Block.func_196246_j((BlockState)belowState));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityMaidBeacon) {
            BlockMaidBeacon.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)ItemMaidBeacon.tileEntityToItemStack((TileEntityMaidBeacon)te));
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)InitItems.MAID_BEACON.get());
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        int maxHeight = world.func_217301_I() - 1;
        if (blockpos.func_177956_o() < maxHeight && world.func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            return super.func_196258_a(context);
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction facing = this.getHorizontalDirection(placer);
        BlockState stateUp = facing == Direction.SOUTH || facing == Direction.NORTH ? (BlockState)this.func_176223_P().func_206870_a(POSITION, (Comparable)((Object)Position.UP_N_S)) : (BlockState)this.func_176223_P().func_206870_a(POSITION, (Comparable)((Object)Position.UP_W_E));
        worldIn.func_180501_a(pos.func_177984_a(), stateUp, 3);
        TileEntity te = worldIn.func_175625_s(pos.func_177984_a());
        if (te instanceof TileEntityMaidBeacon) {
            TileEntityMaidBeacon tileEntityMaidBeacon = (TileEntityMaidBeacon)te;
            ItemMaidBeacon.itemStackToTileEntity(stack, tileEntityMaidBeacon);
            tileEntityMaidBeacon.refresh();
        }
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        switch (direction) {
            default: {
                return state;
            }
            case CLOCKWISE_90: 
            case COUNTERCLOCKWISE_90: 
        }
        if (state.func_177229_b(POSITION) == Position.UP_N_S) {
            return (BlockState)state.func_206870_a(POSITION, (Comparable)((Object)Position.UP_W_E));
        }
        if (state.func_177229_b(POSITION) == Position.UP_W_E) {
            return (BlockState)state.func_206870_a(POSITION, (Comparable)((Object)Position.UP_N_S));
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POSITION});
    }

    private Direction getHorizontalDirection(@Nullable LivingEntity placer) {
        return placer == null ? Direction.NORTH : placer.func_174811_aO();
    }

    public static enum Position implements IStringSerializable
    {
        UP_N_S,
        UP_W_E,
        DOWN;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

