/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockMaidBed
extends HorizontalBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.field_208139_an;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.field_208192_s;
    protected static final VoxelShape BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public BlockMaidBed() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200947_a(SoundType.field_185848_a).func_200943_b(0.2f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(PART, (Comparable)BedPart.FOOT)).func_206870_a((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BASE;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == this.getNeighbourDirection((BedPart)stateIn.func_177229_b(PART), (Direction)stateIn.func_177229_b((Property)field_185512_D))) {
            return facingState.func_203425_a((Block)this) && facingState.func_177229_b(PART) != stateIn.func_177229_b(PART) ? (BlockState)stateIn.func_206870_a((Property)OCCUPIED, facingState.func_177229_b((Property)OCCUPIED)) : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!worldIn.field_72995_K && player.func_184812_l_() && (bedpart = (BedPart)state.func_177229_b(PART)) == BedPart.FOOT && (blockstate = worldIn.func_180495_p(blockpos = pos.func_177972_a(this.getNeighbourDirection(bedpart, (Direction)state.func_177229_b((Property)field_185512_D))))).func_177230_c() == this && blockstate.func_177229_b(PART) == BedPart.HEAD) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, PART, OCCUPIED});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f();
        BlockPos relativePos = context.func_195995_a().func_177972_a(direction);
        return context.func_195991_k().func_180495_p(relativePos).func_196953_a(context) ? (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)direction) : null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D));
            worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a(PART, (Comparable)BedPart.HEAD), 3);
            worldIn.func_230547_a_(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)worldIn, pos, 3);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entity) {
        if (entity.func_226272_bl_()) {
            super.func_176216_a(worldIn, entity);
        } else {
            Vector3d movement = entity.func_213322_ci();
            if (movement.field_72448_b < 0.0) {
                double modulus = entity instanceof LivingEntity ? 1.0 : 0.8;
                entity.func_213293_j(movement.field_72450_a, -movement.field_72448_b * (double)0.66f * modulus, movement.field_72449_c);
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        BlockPos blockpos = pos.func_177967_a((Direction)state.func_177229_b((Property)field_185512_D), state.func_177229_b(PART) == BedPart.HEAD ? 0 : 1);
        return MathHelper.func_180187_c((int)blockpos.func_177958_n(), (int)pos.func_177956_o(), (int)blockpos.func_177952_p());
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean isBed(BlockState state, IBlockReader world, BlockPos pos, @Nullable Entity entity) {
        if (entity instanceof EntityMaid) {
            return true;
        }
        return super.isBed(state, world, pos, entity);
    }

    private Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.func_176734_d();
    }
}

