/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenSwitcherGuiMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.StringUtils;

public class BlockModelSwitcher
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public BlockModelSwitcher() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(50.0f, 1200.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction direction) {
        Direction value = (Direction)state.func_177229_b((Property)FACING);
        if (direction != null) {
            return direction == value.func_176746_e() || direction == value.func_176735_f();
        }
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityModelSwitcher();
    }

    public BlockState func_196258_a(BlockItemUseContext pContext) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)pContext.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> pBuilder) {
        pBuilder.func_206894_a(new Property[]{FACING});
    }

    public void func_220069_a(BlockState pState, World pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        TileEntityModelSwitcher switcher;
        if (pLevel.field_72995_K) {
            return;
        }
        Direction direction = (Direction)pState.func_177229_b((Property)FACING);
        boolean leftSignal = pLevel.func_175651_c(pPos.func_177971_a(direction.func_176735_f().func_176730_m()), direction.func_176735_f()) > 0;
        boolean rightSignal = pLevel.func_175651_c(pPos.func_177971_a(direction.func_176746_e().func_176730_m()), direction.func_176746_e()) > 0;
        boolean hasSignal = leftSignal || rightSignal;
        TileEntity blockEntity = pLevel.func_175625_s(pPos);
        if (blockEntity instanceof TileEntityModelSwitcher && pLevel instanceof ServerWorld && (switcher = (TileEntityModelSwitcher)blockEntity).isPowered() != hasSignal) {
            switcher.setPowered(!switcher.isPowered());
            if (!switcher.isPowered()) {
                return;
            }
            UUID uuid = switcher.getUuid();
            if (uuid == null) {
                return;
            }
            int index = this.calculateIndex(leftSignal, switcher.getInfoList().size(), switcher.getIndex());
            switcher.setIndex(index);
            ServerWorld serverLevel = (ServerWorld)pLevel;
            Entity entity = serverLevel.func_217461_a(uuid);
            if (entity instanceof EntityMaid && entity.func_70089_S()) {
                this.setMaidData(switcher, (EntityMaid)entity);
            }
        }
    }

    private void setMaidData(TileEntityModelSwitcher switcher, EntityMaid maid) {
        TileEntityModelSwitcher.ModeInfo modelInfo = switcher.getModelInfo();
        if (modelInfo != null) {
            maid.setModelId(modelInfo.getModelId().toString());
            if (StringUtils.isNotBlank((CharSequence)modelInfo.getText())) {
                maid.func_200203_b((ITextComponent)new StringTextComponent(modelInfo.getText()));
                maid.func_174805_g(true);
            } else {
                maid.func_200203_b(null);
                maid.func_174805_g(false);
            }
            BlockPos blockPos = maid.func_233580_cy_();
            maid.func_70107_b((double)blockPos.func_177958_n() + 0.5, blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5);
            maid.field_70177_z = modelInfo.getDirection().func_185119_l();
            maid.func_70034_d(modelInfo.getDirection().func_185119_l());
            maid.func_181013_g(modelInfo.getDirection().func_185119_l());
        }
    }

    private int calculateIndex(boolean leftSignal, int size, int index) {
        index = leftSignal ? (index < size - 1 ? ++index : 0) : (index > 0 ? --index : size - 1);
        return index;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityModelSwitcher) {
            if (!worldIn.field_72995_K) {
                NetworkHandler.sendToClientPlayer(new OpenSwitcherGuiMessage(pos), player);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_180633_a(World pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        TileEntity te = pLevel.func_175625_s(pPos);
        if (te instanceof TileEntityModelSwitcher) {
            TileEntityModelSwitcher tileEntityModelSwitcher = (TileEntityModelSwitcher)te;
            ItemModelSwitcher.itemStackToTileEntity(pStack, tileEntityModelSwitcher);
            tileEntityModelSwitcher.refresh();
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityModelSwitcher) {
            BlockModelSwitcher.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)ItemModelSwitcher.tileEntityToItemStack((TileEntityModelSwitcher)te));
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public BlockRenderType func_149645_b(BlockState pState) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState pState, Rotation pRot) {
        return (BlockState)pState.func_206870_a((Property)FACING, (Comparable)pRot.func_185831_a((Direction)pState.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState pState, Mirror pMirror) {
        return pState.func_185907_a(pMirror.func_185800_a((Direction)pState.func_177229_b((Property)FACING)));
    }
}

