/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.item.ItemFilm;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityShrine;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockShrine
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.func_208617_a((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)});

    public BlockShrine() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 3.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (hand == Hand.MAIN_HAND && worldIn.func_175625_s(pos) instanceof TileEntityShrine) {
            TileEntityShrine shrine = (TileEntityShrine)worldIn.func_175625_s(pos);
            if (playerIn.func_225608_bj_()) {
                if (!shrine.isEmpty()) {
                    ItemStack storageItem = shrine.extractStorageItem();
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)storageItem);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }
            if (shrine.isEmpty()) {
                if (shrine.canInsert(playerIn.func_184614_ca())) {
                    shrine.insertStorageItem(ItemHandlerHelper.copyStackWithSize((ItemStack)playerIn.func_184614_ca(), (int)1));
                    playerIn.func_184614_ca().func_190918_g(1);
                    return ActionResultType.SUCCESS;
                }
                if (!worldIn.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.shrine.not_film"), Util.field_240973_b_);
                }
                return ActionResultType.PASS;
            }
            if (playerIn.func_184614_ca().func_190926_b()) {
                if (playerIn.func_110143_aJ() < playerIn.func_110138_aP() / 2.0f + 1.0f) {
                    if (!worldIn.field_72995_K) {
                        playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.shrine.health_low"), Util.field_240973_b_);
                    }
                    return ActionResultType.FAIL;
                }
                playerIn.func_70606_j(0.25f);
                ItemStack film = shrine.getStorageItem();
                ItemFilm.filmToMaid(film, worldIn, pos.func_177984_a(), playerIn);
            }
        }
        return super.func_225533_a_(state, worldIn, pos, playerIn, hand, hit);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityShrine shrine;
        ItemStack storageItem;
        TileEntity blockEntity = worldIn.func_175625_s(pos);
        if (blockEntity instanceof TileEntityShrine && !(storageItem = (shrine = (TileEntityShrine)blockEntity).extractStorageItem()).func_190926_b()) {
            Block.func_180635_a((World)worldIn, (BlockPos)pos.func_177982_a(0, 1, 0), (ItemStack)storageItem);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityShrine();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

