/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockStatue
extends Block {
    public static final BooleanProperty IS_TINY = BooleanProperty.func_177716_a((String)"is_tiny");

    public BlockStatue() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(1.0f, 2.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)IS_TINY, (Comparable)Boolean.valueOf(false)));
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            this.getStatue((IBlockReader)worldIn, pos).ifPresent(statue -> {
                this.restoreClayBlock(worldIn, pos, (TileEntityStatue)((Object)statue));
                if (!player.func_184812_l_()) {
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Blocks.field_150435_aG));
                }
            });
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            this.getStatue((IBlockReader)world, pos).ifPresent(statue -> this.restoreClayBlock(world, pos, (TileEntityStatue)((Object)statue)));
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{IS_TINY});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityStatue();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)Blocks.field_150435_aG);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, Blocks.field_150435_aG.func_176223_P());
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target instanceof BlockRayTraceResult && world instanceof ClientWorld) {
            BlockRayTraceResult blockTarget = (BlockRayTraceResult)target;
            BlockPos pos = blockTarget.func_216350_a();
            ClientWorld clientWorld = (ClientWorld)world;
            this.crack(clientWorld, pos, Blocks.field_150435_aG.func_176223_P(), blockTarget.func_216354_b());
        }
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private Optional<TileEntityStatue> getStatue(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityStatue) {
            return Optional.of((TileEntityStatue)te);
        }
        return Optional.empty();
    }

    private void restoreClayBlock(@Nonnull World worldIn, @Nonnull BlockPos pos, TileEntityStatue statue) {
        List<BlockPos> posList = statue.getAllBlocks();
        for (BlockPos storagePos : posList) {
            if (storagePos.equals((Object)pos)) continue;
            this.getStatue((IBlockReader)worldIn, storagePos).ifPresent(s -> worldIn.func_180501_a(storagePos, Blocks.field_150435_aG.func_176223_P(), 3));
        }
    }

    public boolean func_149653_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)IS_TINY);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150480_ab)) {
            this.getStatue((IBlockReader)worldIn, pos).ifPresent(statue -> {
                worldIn.func_175656_a(pos, ((Block)InitBlocks.GARAGE_KIT.get()).func_176223_P());
                worldIn.func_217379_c(1501, pos, 0);
                TileEntity te = worldIn.func_175625_s(pos);
                if (te instanceof TileEntityGarageKit && statue.getExtraMaidData() != null) {
                    ((TileEntityGarageKit)te).setData(statue.getFacing(), statue.getExtraMaidData());
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void crack(ClientWorld world, BlockPos pos, BlockState state, Direction side) {
        if (state.func_185901_i() != BlockRenderType.INVISIBLE) {
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o();
            int posZ = pos.func_177952_p();
            AxisAlignedBB aabb = state.func_196954_c((IBlockReader)world, pos).func_197752_a();
            double x = (double)posX + this.RANDOM.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a - 0.2) + 0.1 + aabb.field_72340_a;
            double y = (double)posY + this.RANDOM.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b - 0.2) + 0.1 + aabb.field_72338_b;
            double z = (double)posZ + this.RANDOM.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c - 0.2) + 0.1 + aabb.field_72339_c;
            if (side == Direction.DOWN) {
                y = (double)posY + aabb.field_72338_b - 0.1;
            }
            if (side == Direction.UP) {
                y = (double)posY + aabb.field_72337_e + 0.1;
            }
            if (side == Direction.NORTH) {
                z = (double)posZ + aabb.field_72339_c - 0.1;
            }
            if (side == Direction.SOUTH) {
                z = (double)posZ + aabb.field_72334_f + 0.1;
            }
            if (side == Direction.WEST) {
                x = (double)posX + aabb.field_72340_a - 0.1;
            }
            if (side == Direction.EAST) {
                x = (double)posX + aabb.field_72336_d + 0.1;
            }
            DiggingParticle diggingParticle = new DiggingParticle(world, x, y, z, 0.0, 0.0, 0.0, state);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(diggingParticle.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
    }
}

