/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block.multiblock;

import com.github.tartaricacid.touhoulittlemaid.api.block.IMultiBlock;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;

public class MultiBlockAltar
implements IMultiBlock {
    private static final ResourceLocation ALTAR_SOUTH = new ResourceLocation("touhou_little_maid", "altar_south");
    private static final ResourceLocation ALTAR_NORTH = new ResourceLocation("touhou_little_maid", "altar_north");
    private static final ResourceLocation ALTAR_EAST = new ResourceLocation("touhou_little_maid", "altar_east");
    private static final ResourceLocation ALTAR_WEST = new ResourceLocation("touhou_little_maid", "altar_west");
    private static final BlockPos SOUTH_POS = new BlockPos(-4, -3, 0);
    private static final BlockPos NORTH_POS = new BlockPos(-3, -3, -7);
    private static final BlockPos EAST_POS = new BlockPos(0, -3, -3);
    private static final BlockPos WEST_POS = new BlockPos(-7, -3, -4);

    @Override
    public boolean isCoreBlock(BlockState blockState) {
        return blockState.func_203425_a(Blocks.field_196570_aZ);
    }

    @Override
    public boolean isMatch(World world, BlockPos posStart, Direction direction, Template template) {
        Template.Palette palette = (Template.Palette)template.field_204769_a.get(0);
        for (Template.BlockInfo blockInfo : palette.func_237157_a_()) {
            if (world.func_180495_p(posStart.func_177971_a((Vector3i)blockInfo.field_186242_a)).equals(blockInfo.field_186243_b)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void build(World worldIn, BlockPos posStart, Direction direction, Template template) {
        PosListData posList = new PosListData();
        PosListData canPlaceItemPosList = new PosListData();
        Template.Palette palette = (Template.Palette)template.field_204769_a.get(0);
        for (Template.BlockInfo blockInfo : palette.func_237157_a_()) {
            posList.add(posStart.func_177971_a((Vector3i)blockInfo.field_186242_a));
            if (blockInfo.field_186242_a.func_177956_o() != 2 || !blockInfo.field_186243_b.func_203425_a(Blocks.field_196617_K)) continue;
            canPlaceItemPosList.add(posStart.func_177971_a((Vector3i)blockInfo.field_186242_a));
        }
        BlockPos currentCenterPos = posStart.func_177973_b((Vector3i)this.getCenterPos(direction));
        for (Template.BlockInfo blockInfo : palette.func_237157_a_()) {
            BlockPos currentPos = posStart.func_177971_a((Vector3i)blockInfo.field_186242_a);
            worldIn.func_180501_a(currentPos, ((Block)InitBlocks.ALTAR.get()).func_176223_P(), 3);
            TileEntity te = worldIn.func_175625_s(currentPos);
            if (!(te instanceof TileEntityAltar)) continue;
            boolean isRender = currentPos.equals((Object)currentCenterPos);
            boolean canPlaceItem = blockInfo.field_186242_a.func_177956_o() == 2 && blockInfo.field_186243_b.func_203425_a(Blocks.field_196617_K);
            ((TileEntityAltar)te).setForgeData(blockInfo.field_186243_b, isRender, canPlaceItem, direction, posList, canPlaceItemPosList);
        }
    }

    @Override
    public boolean directionIsSuitable(Direction direction) {
        return direction != Direction.DOWN && direction != Direction.UP;
    }

    @Override
    public BlockPos getCenterPos(Direction facing) {
        switch (facing) {
            case NORTH: {
                return SOUTH_POS;
            }
            case EAST: {
                return WEST_POS;
            }
            case WEST: {
                return EAST_POS;
            }
        }
        return NORTH_POS;
    }

    @Override
    public Template getTemplate(ServerWorld world, Direction facing) {
        switch (facing) {
            case NORTH: {
                return this.getAltarTemplate(world, ALTAR_SOUTH);
            }
            case EAST: {
                return this.getAltarTemplate(world, ALTAR_WEST);
            }
            case WEST: {
                return this.getAltarTemplate(world, ALTAR_EAST);
            }
        }
        return this.getAltarTemplate(world, ALTAR_NORTH);
    }

    private Template getAltarTemplate(ServerWorld world, ResourceLocation location) {
        return world.func_184163_y().func_200220_a(location);
    }
}

