/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.capability;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;

public class MaidNumCapability {
    private int num = 0;
    private boolean dirty;

    public boolean canAdd() {
        return this.num + 1 <= this.getMaxNum();
    }

    public void add() {
        this.add(1);
    }

    public void add(int num) {
        this.num = num + this.num <= this.getMaxNum() ? (this.num += num) : this.getMaxNum();
        this.markDirty();
    }

    public void min(int num) {
        this.num = num <= this.num ? (this.num -= num) : 0;
        this.markDirty();
    }

    public void set(int num) {
        this.num = MathHelper.func_76125_a((int)num, (int)0, (int)this.getMaxNum());
        this.markDirty();
    }

    public int getMaxNum() {
        return (Integer)MaidConfig.OWNER_MAX_MAID_NUM.get();
    }

    public int get() {
        return this.num;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public static class Storage
    implements Capability.IStorage<MaidNumCapability> {
        @Nullable
        public INBT writeNBT(Capability<MaidNumCapability> capability, MaidNumCapability instance, Direction side) {
            return IntNBT.func_229692_a_((int)instance.get());
        }

        public void readNBT(Capability<MaidNumCapability> capability, MaidNumCapability instance, Direction side, INBT nbt) {
            instance.set(((IntNBT)nbt).func_150287_d());
        }
    }
}

