/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.capability;

import javax.annotation.Nullable;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;

public class PowerCapability {
    public static final float MAX_POWER = 5.0f;
    private float power = 0.0f;
    private boolean dirty;

    public void add(float points) {
        this.power = points + this.power <= 5.0f ? (this.power += points) : 5.0f;
        this.markDirty();
    }

    public void min(float points) {
        this.power = points <= this.power ? (this.power -= points) : 0.0f;
        this.markDirty();
    }

    public void set(float points) {
        this.power = MathHelper.func_76131_a((float)points, (float)0.0f, (float)5.0f);
        this.markDirty();
    }

    public float get() {
        return this.power;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public static class Storage
    implements Capability.IStorage<PowerCapability> {
        @Nullable
        public INBT writeNBT(Capability<PowerCapability> capability, PowerCapability instance, Direction side) {
            return FloatNBT.func_229689_a_((float)instance.get());
        }

        public void readNBT(Capability<PowerCapability> capability, PowerCapability instance, Direction side, INBT nbt) {
            instance.set(((FloatNBT)nbt).func_150288_h());
        }
    }
}

