/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationState;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionArmor;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalHold;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalSwing;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionalUse;
import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoMaidEntity;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.PlayState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.AnimationBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public final class AnimationManager {
    private static AnimationManager MANAGER;
    private final Int2ObjectOpenHashMap<LinkedList<AnimationState>> data = new Int2ObjectOpenHashMap();

    public static AnimationManager getInstance() {
        if (MANAGER == null) {
            MANAGER = new AnimationManager();
        }
        return MANAGER;
    }

    @Nonnull
    private static <P extends IAnimatable> PlayState playLoopAnimation(AnimationEvent<P> event, String animationName) {
        return AnimationManager.playAnimation(event, animationName, ILoopType.EDefaultLoopTypes.LOOP);
    }

    @Nonnull
    private static <P extends IAnimatable> PlayState playAnimation(AnimationEvent<P> event, String animationName, ILoopType loopType) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName, loopType));
        return PlayState.CONTINUE;
    }

    @Nonnull
    private static <P extends IAnimatable> PlayState playAnimation(AnimationEvent<P> event, String animationName) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation(animationName));
        return PlayState.CONTINUE;
    }

    public void register(AnimationState state) {
        if (this.data.containsKey(state.getPriority())) {
            ((LinkedList)this.data.get(state.getPriority())).add(state);
        } else {
            LinkedList states = Lists.newLinkedList();
            states.add(state);
            this.data.put(state.getPriority(), (Object)states);
        }
    }

    public PlayState predicateParallel(AnimationEvent<GeckoMaidEntity> event, String animationName) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return PlayState.STOP;
        }
        return AnimationManager.playLoopAnimation(event, animationName);
    }

    @Nonnull
    public PlayState predicateMain(AnimationEvent<GeckoMaidEntity> event) {
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        for (int i = 0; i <= 4; ++i) {
            if (!this.data.containsKey(i)) continue;
            LinkedList states = (LinkedList)this.data.get(i);
            for (AnimationState state : states) {
                if (!state.getPredicate().test(maid, event)) continue;
                String animationName = state.getAnimationName();
                ILoopType loopType = state.getLoopType();
                return AnimationManager.playAnimation(event, animationName, loopType);
            }
        }
        return PlayState.STOP;
    }

    public PlayState predicateOffhandHold(AnimationEvent<GeckoMaidEntity> event) {
        String name;
        ResourceLocation id;
        ConditionalHold conditionalHold;
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (!maid.func_184592_cb().func_190926_b() && this.checkSwingAndUse(maid, Hand.OFF_HAND) && (conditionalHold = ConditionManager.getHoldOffhand(id = event.getAnimatable().getAnimation())) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalHold.doTest(maid, Hand.OFF_HAND)})) {
            return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public PlayState predicateMainhandHold(AnimationEvent<GeckoMaidEntity> event) {
        String name;
        ResourceLocation id;
        ConditionalHold conditionalHold;
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (!maid.field_82175_bq && !maid.func_184587_cr()) {
            ItemStack mainHandItem = maid.func_184586_b(Hand.MAIN_HAND);
            if (mainHandItem.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)mainHandItem)) {
                return AnimationManager.playAnimation(event, "hold_mainhand:charged_crossbow", ILoopType.EDefaultLoopTypes.LOOP);
            }
            ItemStack offhandItem = maid.func_184586_b(Hand.OFF_HAND);
            if (offhandItem.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)offhandItem)) {
                return AnimationManager.playAnimation(event, "hold_offhand:charged_crossbow", ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        if (!maid.func_184614_ca().func_190926_b() && this.checkSwingAndUse(maid, Hand.MAIN_HAND) && (conditionalHold = ConditionManager.getHoldMainhand(id = event.getAnimatable().getAnimation())) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalHold.doTest(maid, Hand.MAIN_HAND)})) {
            return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public PlayState predicateSwing(AnimationEvent<GeckoMaidEntity> event) {
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid.field_82175_bq && !maid.func_70608_bn()) {
            String name;
            ResourceLocation id;
            ConditionalSwing conditionalSwing;
            if (maid.field_110158_av == 0) {
                event.getController().shouldResetTick = true;
                event.getController().adjustTick(0.0);
            }
            if ((conditionalSwing = ConditionManager.getSwing(id = event.getAnimatable().getAnimation())) != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalSwing.doTest(maid, maid.field_184622_au)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
            return AnimationManager.playAnimation(event, "swing_hand", ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public PlayState predicateUse(AnimationEvent<GeckoMaidEntity> event) {
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid.func_184587_cr() && !maid.func_70608_bn()) {
            String name;
            if (maid.func_184612_cw() == 1) {
                event.getController().shouldResetTick = true;
                event.getController().adjustTick(0.0);
            }
            if (maid.func_184600_cs() == Hand.MAIN_HAND) {
                String name2;
                ResourceLocation id = event.getAnimatable().getAnimation();
                ConditionalUse conditionalUse = ConditionManager.getUseMainhand(id);
                if (conditionalUse != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name2 = conditionalUse.doTest(maid, Hand.MAIN_HAND)})) {
                    return AnimationManager.playAnimation(event, name2, ILoopType.EDefaultLoopTypes.LOOP);
                }
                return AnimationManager.playAnimation(event, "use_mainhand", ILoopType.EDefaultLoopTypes.LOOP);
            }
            ResourceLocation id = event.getAnimatable().getAnimation();
            ConditionalUse conditionalUse = ConditionManager.getUseOffhand(id);
            if (conditionalUse != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name = conditionalUse.doTest(maid, Hand.OFF_HAND)})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
            return AnimationManager.playAnimation(event, "use_offhand", ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public PlayState predicateBeg(AnimationEvent<GeckoMaidEntity> event) {
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        if (maid.isBegging()) {
            return AnimationManager.playAnimation(event, "beg", ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    public PlayState predicateArmor(AnimationEvent<GeckoMaidEntity> event, EquipmentSlotType slot) {
        EntityMaid maid = event.getAnimatable().getMaid();
        if (maid == null) {
            return PlayState.STOP;
        }
        ItemStack itemBySlot = maid.func_184582_a(slot);
        if (itemBySlot.func_190926_b()) {
            return PlayState.STOP;
        }
        ResourceLocation id = event.getAnimatable().getAnimation();
        ConditionArmor conditionArmor = ConditionManager.getArmor(id);
        if (conditionArmor != null) {
            String name = conditionArmor.doTest(maid, slot);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
                return AnimationManager.playAnimation(event, name, ILoopType.EDefaultLoopTypes.LOOP);
            }
        }
        ResourceLocation animation = event.getAnimatable().getAnimation();
        String defaultName = slot.func_188450_d() + ":default";
        if (GeckoLibCache.getInstance().getAnimations().get(animation).animations().containsKey(defaultName)) {
            return AnimationManager.playAnimation(event, defaultName, ILoopType.EDefaultLoopTypes.LOOP);
        }
        return PlayState.STOP;
    }

    private boolean checkSwingAndUse(EntityMaid maid, Hand hand) {
        if (maid.field_82175_bq && maid.field_184622_au == hand) {
            return false;
        }
        return !maid.func_184587_cr() || maid.func_184600_cs() != hand;
    }
}

