/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationManager;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationState;
import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoMaidEntity;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.LazyVariable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.MolangUtils;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class AnimationRegister {
    private static final double MIN_SPEED = 0.05;

    public static void registerAnimationState() {
        AnimationRegister.register("death", ILoopType.EDefaultLoopTypes.PLAY_ONCE, 0, (maid, event) -> maid.func_233643_dh_());
        AnimationRegister.register("sleep", 0, (maid, event) -> maid.func_213283_Z() == Pose.SLEEPING);
        AnimationRegister.register("swim", 0, (maid, event) -> maid.func_203007_ba());
        AnimationRegister.register("boat", 1, (maid, event) -> maid.func_184187_bx() instanceof BoatEntity);
        AnimationRegister.register("gomoku", 1, (maid, event) -> AnimationRegister.isJoy(maid, Type.GOMOKU));
        AnimationRegister.register("bookshelf", 1, (maid, event) -> AnimationRegister.isJoy(maid, Type.BOOKSHELF));
        AnimationRegister.register("computer", 1, (maid, event) -> AnimationRegister.isJoy(maid, Type.COMPUTER));
        AnimationRegister.register("keyboard", 1, (maid, event) -> AnimationRegister.isJoy(maid, Type.KEYBOARD));
        AnimationRegister.register("sit", 1, (maid, event) -> maid.func_233684_eK_());
        AnimationRegister.register("chair", 1, (maid, event) -> maid.func_184218_aH());
        AnimationRegister.register("swim_stand", 2, (maid, event) -> maid.func_70090_H());
        AnimationRegister.register("attacked", ILoopType.EDefaultLoopTypes.PLAY_ONCE, 2, (maid, event) -> maid.field_70737_aN > 0);
        AnimationRegister.register("jump", 2, (maid, event) -> !maid.func_233570_aj_() && !maid.func_70090_H());
        AnimationRegister.register("run", 3, (maid, event) -> maid.func_233570_aj_() && maid.func_70051_ag());
        AnimationRegister.register("walk", 3, (maid, event) -> maid.func_233570_aj_() && (double)event.getLimbSwingAmount() > 0.05);
        AnimationRegister.register("idle", 4, (maid, event) -> true);
    }

    public static void registerVariables() {
        MolangParser parser = GeckoLibCache.getInstance().parser;
        parser.register(new LazyVariable("query.actor_count", 0.0));
        parser.register(new LazyVariable("query.anim_time", 0.0));
        parser.register(new LazyVariable("query.body_x_rotation", 0.0));
        parser.register(new LazyVariable("query.body_y_rotation", 0.0));
        parser.register(new LazyVariable("query.cardinal_facing_2d", 0.0));
        parser.register(new LazyVariable("query.distance_from_camera", 0.0));
        parser.register(new LazyVariable("query.equipment_count", 0.0));
        parser.register(new LazyVariable("query.eye_target_x_rotation", 0.0));
        parser.register(new LazyVariable("query.eye_target_y_rotation", 0.0));
        parser.register(new LazyVariable("query.ground_speed", 0.0));
        parser.register(new LazyVariable("query.has_cape", 0.0));
        parser.register(new LazyVariable("query.has_rider", 0.0));
        parser.register(new LazyVariable("query.head_x_rotation", 0.0));
        parser.register(new LazyVariable("query.head_y_rotation", 0.0));
        parser.register(new LazyVariable("query.health", 0.0));
        parser.register(new LazyVariable("query.hurt_time", 0.0));
        parser.register(new LazyVariable("query.is_eating", 0.0));
        parser.register(new LazyVariable("query.is_first_person", 0.0));
        parser.register(new LazyVariable("query.is_in_water", 0.0));
        parser.register(new LazyVariable("query.is_in_water_or_rain", 0.0));
        parser.register(new LazyVariable("query.is_jumping", 0.0));
        parser.register(new LazyVariable("query.is_on_fire", 0.0));
        parser.register(new LazyVariable("query.is_on_ground", 0.0));
        parser.register(new LazyVariable("query.is_playing_dead", 0.0));
        parser.register(new LazyVariable("query.is_riding", 0.0));
        parser.register(new LazyVariable("query.is_sleeping", 0.0));
        parser.register(new LazyVariable("query.is_sneaking", 0.0));
        parser.register(new LazyVariable("query.is_spectator", 0.0));
        parser.register(new LazyVariable("query.is_sprinting", 0.0));
        parser.register(new LazyVariable("query.is_swimming", 0.0));
        parser.register(new LazyVariable("query.is_using_item", 0.0));
        parser.register(new LazyVariable("query.item_in_use_duration", 0.0));
        parser.register(new LazyVariable("query.item_max_use_duration", 0.0));
        parser.register(new LazyVariable("query.item_remaining_use_duration", 0.0));
        parser.register(new LazyVariable("query.life_time", 0.0));
        parser.register(new LazyVariable("query.max_health", 0.0));
        parser.register(new LazyVariable("query.modified_distance_moved", 0.0));
        parser.register(new LazyVariable("query.moon_phase", 0.0));
        parser.register(new LazyVariable("query.player_level", 0.0));
        parser.register(new LazyVariable("query.time_of_day", 0.0));
        parser.register(new LazyVariable("query.time_stamp", 0.0));
        parser.register(new LazyVariable("query.vertical_speed", 0.0));
        parser.register(new LazyVariable("query.walk_distance", 0.0));
        parser.register(new LazyVariable("query.yaw_speed", 0.0));
        parser.register(new LazyVariable("ysm.head_yaw", 0.0));
        parser.register(new LazyVariable("ysm.head_pitch", 0.0));
        parser.register(new LazyVariable("ysm.has_helmet", 0.0));
        parser.register(new LazyVariable("ysm.has_chest_plate", 0.0));
        parser.register(new LazyVariable("ysm.has_leggings", 0.0));
        parser.register(new LazyVariable("ysm.has_boots", 0.0));
        parser.register(new LazyVariable("ysm.has_mainhand", 0.0));
        parser.register(new LazyVariable("ysm.has_offhand", 0.0));
        parser.register(new LazyVariable("ysm.has_elytra", 0.0));
        parser.register(new LazyVariable("ysm.elytra_rot_x", 0.0));
        parser.register(new LazyVariable("ysm.elytra_rot_y", 0.0));
        parser.register(new LazyVariable("ysm.elytra_rot_z", 0.0));
        parser.register(new LazyVariable("ysm.is_close_eyes", 0.0));
        parser.register(new LazyVariable("ysm.is_passenger", 0.0));
        parser.register(new LazyVariable("ysm.is_sleep", 0.0));
        parser.register(new LazyVariable("ysm.is_sneak", 0.0));
        parser.register(new LazyVariable("ysm.is_riptide", 0.0));
        parser.register(new LazyVariable("ysm.armor_value", 0.0));
        parser.register(new LazyVariable("ysm.hurt_time", 0.0));
        parser.register(new LazyVariable("ysm.food_level", 20.0));
        parser.register(new LazyVariable("ysm.first_person_mod_hide", 0.0));
        parser.register(new LazyVariable("tlm.is_begging", 0.0));
        parser.register(new LazyVariable("tlm.is_sitting", 0.0));
        parser.register(new LazyVariable("tlm.has_backpack", 0.0));
    }

    public static void setParserValue(AnimationEvent<GeckoMaidEntity> animationEvent, MolangParser parser, EntityModelData data, EntityMaid maid) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        parser.setValue("query.actor_count", () -> mc.field_71441_e.func_217425_f());
        parser.setValue("query.body_x_rotation", () -> maid.field_70125_A);
        parser.setValue("query.body_y_rotation", () -> MathHelper.func_76142_g((float)maid.field_70177_z));
        parser.setValue("query.cardinal_facing_2d", () -> maid.func_174811_aO().func_176745_a());
        parser.setValue("query.distance_from_camera", () -> mc.field_71460_t.func_215316_n().func_216785_c().func_72438_d(maid.func_213303_ch()));
        parser.setValue("query.equipment_count", () -> AnimationRegister.getEquipmentCount(maid));
        parser.setValue("query.eye_target_x_rotation", () -> maid.func_195050_f(0.0f));
        parser.setValue("query.eye_target_y_rotation", () -> maid.func_195046_g(0.0f));
        parser.setValue("query.ground_speed", () -> AnimationRegister.getGroundSpeed(maid));
        parser.setValue("query.has_rider", () -> MolangUtils.booleanToFloat(maid.func_184207_aI()));
        parser.setValue("query.head_x_rotation", () -> data.netHeadYaw);
        parser.setValue("query.head_y_rotation", () -> data.headPitch);
        parser.setValue("query.health", () -> ((EntityMaid)maid).func_110143_aJ());
        parser.setValue("query.hurt_time", () -> maid.field_70737_aN);
        parser.setValue("query.is_eating", () -> MolangUtils.booleanToFloat(maid.func_184607_cu().func_77975_n() == UseAction.EAT));
        parser.setValue("query.is_first_person", () -> MolangUtils.booleanToFloat(mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON));
        parser.setValue("query.is_in_water", () -> MolangUtils.booleanToFloat(maid.func_70090_H()));
        parser.setValue("query.is_in_water_or_rain", () -> MolangUtils.booleanToFloat(maid.func_203008_ap()));
        parser.setValue("query.is_jumping", () -> MolangUtils.booleanToFloat(!maid.func_184218_aH() && !maid.func_233570_aj_() && !maid.func_70090_H()));
        parser.setValue("query.is_on_fire", () -> MolangUtils.booleanToFloat(maid.func_70027_ad()));
        parser.setValue("query.is_on_ground", () -> MolangUtils.booleanToFloat(maid.func_233570_aj_()));
        parser.setValue("query.is_playing_dead", () -> MolangUtils.booleanToFloat(maid.func_233643_dh_()));
        parser.setValue("query.is_riding", () -> MolangUtils.booleanToFloat(maid.func_184218_aH()));
        parser.setValue("query.is_sleeping", () -> MolangUtils.booleanToFloat(maid.func_70608_bn()));
        parser.setValue("query.is_sneaking", () -> MolangUtils.booleanToFloat(maid.func_233570_aj_() && maid.func_213283_Z() == Pose.CROUCHING));
        parser.setValue("query.is_spectator", () -> MolangUtils.booleanToFloat(maid.func_175149_v()));
        parser.setValue("query.is_sprinting", () -> MolangUtils.booleanToFloat(maid.func_70051_ag()));
        parser.setValue("query.is_swimming", () -> MolangUtils.booleanToFloat(maid.func_203007_ba()));
        parser.setValue("query.is_using_item", () -> MolangUtils.booleanToFloat(maid.func_184587_cr()));
        parser.setValue("query.item_in_use_duration", () -> (double)maid.func_184612_cw() / 20.0);
        parser.setValue("query.item_max_use_duration", () -> AnimationRegister.getMaxUseDuration(maid) / 20.0);
        parser.setValue("query.item_remaining_use_duration", () -> (double)maid.func_184605_cv() / 20.0);
        parser.setValue("query.max_health", () -> ((EntityMaid)maid).func_110138_aP());
        parser.setValue("query.modified_distance_moved", () -> maid.field_70140_Q);
        parser.setValue("query.moon_phase", () -> mc.field_71441_e.func_242414_af());
        parser.setValue("query.player_level", () -> maid.getExperience() / 120);
        parser.setValue("query.time_of_day", () -> MolangUtils.normalizeTime(mc.field_71441_e.func_72820_D()));
        parser.setValue("query.time_stamp", () -> mc.field_71441_e.func_72820_D());
        parser.setValue("query.vertical_speed", () -> AnimationRegister.getVerticalSpeed(maid));
        parser.setValue("query.walk_distance", () -> maid.field_82151_R);
        parser.setValue("query.yaw_speed", () -> AnimationRegister.getYawSpeed(animationEvent, maid));
        parser.setValue("ysm.head_yaw", () -> data.netHeadYaw);
        parser.setValue("ysm.head_pitch", () -> data.headPitch);
        parser.setValue("ysm.has_helmet", () -> AnimationRegister.getSlotValue(maid, EquipmentSlotType.HEAD));
        parser.setValue("ysm.has_chest_plate", () -> AnimationRegister.getSlotValue(maid, EquipmentSlotType.CHEST));
        parser.setValue("ysm.has_leggings", () -> AnimationRegister.getSlotValue(maid, EquipmentSlotType.LEGS));
        parser.setValue("ysm.has_boots", () -> AnimationRegister.getSlotValue(maid, EquipmentSlotType.FEET));
        parser.setValue("ysm.has_mainhand", () -> AnimationRegister.getSlotValue(maid, EquipmentSlotType.MAINHAND));
        parser.setValue("ysm.has_offhand", () -> AnimationRegister.getSlotValue(maid, EquipmentSlotType.OFFHAND));
        parser.setValue("ysm.has_elytra", () -> MolangUtils.booleanToFloat(maid.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == Items.field_185160_cR));
        parser.setValue("ysm.is_close_eyes", () -> AnimationRegister.getEyeCloseState(animationEvent, maid));
        parser.setValue("ysm.is_passenger", () -> MolangUtils.booleanToFloat(maid.func_184218_aH()));
        parser.setValue("ysm.is_sleep", () -> MolangUtils.booleanToFloat(maid.func_213283_Z() == Pose.SLEEPING));
        parser.setValue("ysm.is_sneak", () -> MolangUtils.booleanToFloat(maid.func_233570_aj_() && maid.func_213283_Z() == Pose.CROUCHING));
        parser.setValue("ysm.is_riptide", () -> MolangUtils.booleanToFloat(maid.func_204805_cN()));
        parser.setValue("ysm.armor_value", () -> ((EntityMaid)maid).func_70658_aO());
        parser.setValue("ysm.hurt_time", () -> maid.field_70737_aN);
        parser.setValue("tlm.is_begging", () -> MolangUtils.booleanToFloat(maid.isBegging()));
        parser.setValue("tlm.is_sitting", () -> MolangUtils.booleanToFloat(maid.func_233684_eK_()));
        parser.setValue("tlm.has_backpack", () -> MolangUtils.booleanToFloat(maid.hasBackpack()));
    }

    private static void register(String animationName, ILoopType loopType, int priority, BiPredicate<EntityMaid, AnimationEvent<GeckoMaidEntity>> predicate) {
        AnimationManager manager = AnimationManager.getInstance();
        manager.register(new AnimationState(animationName, loopType, priority, predicate));
    }

    private static void register(String animationName, int priority, BiPredicate<EntityMaid, AnimationEvent<GeckoMaidEntity>> predicate) {
        AnimationRegister.register(animationName, ILoopType.EDefaultLoopTypes.LOOP, priority, predicate);
    }

    private static int getEquipmentCount(EntityMaid maid) {
        int count = 0;
        for (ItemStack s : maid.func_184193_aE()) {
            if (s.func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    private static double getMaxUseDuration(EntityMaid maid) {
        ItemStack useItem = maid.func_184607_cu();
        if (useItem.func_190926_b()) {
            return 0.0;
        }
        return useItem.func_77988_m();
    }

    private static float getYawSpeed(AnimationEvent<GeckoMaidEntity> animationEvent, EntityMaid maid) {
        double seekTime = animationEvent.getAnimationTick();
        return maid.func_195046_g((float)seekTime - maid.func_195046_g((float)seekTime - 0.1f));
    }

    private static float getGroundSpeed(EntityMaid maid) {
        Vector3d velocity = maid.func_213322_ci();
        return 20.0f * MathHelper.func_76129_c((float)((float)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c)));
    }

    private static float getVerticalSpeed(EntityMaid maid) {
        return 20.0f * (float)(maid.func_213303_ch().field_72448_b - maid.field_70167_r);
    }

    private static double getEyeCloseState(AnimationEvent<GeckoMaidEntity> animationEvent, EntityMaid maid) {
        double remainder = (animationEvent.getAnimationTick() + (double)(Math.abs(maid.func_110124_au().getLeastSignificantBits()) % 10L)) % 90.0;
        boolean isBlinkTime = 85.0 < remainder && remainder < 90.0;
        return MolangUtils.booleanToFloat(maid.func_70608_bn() || isBlinkTime);
    }

    private static double getSlotValue(EntityMaid maid, EquipmentSlotType slot) {
        return MolangUtils.booleanToFloat(!maid.func_184582_a(slot).func_190926_b());
    }

    private static boolean isJoy(EntityMaid maid, Type type) {
        if (maid.func_184187_bx() instanceof EntitySit) {
            EntitySit sit = (EntitySit)maid.func_184187_bx();
            return sit.getJoyType().equals(type.getTypeName());
        }
        return false;
    }
}

