/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;

public class ConditionArmor {
    private static final Pattern ID_PRE_REG = Pattern.compile("^(.+?)\\$(.*?)$");
    private static final Pattern TAG_PRE_REG = Pattern.compile("^(.+?)#(.*?)$");
    private static final String EMPTY = "";
    private final Map<EquipmentSlotType, List<ResourceLocation>> idTest = Maps.newHashMap();
    private final Map<EquipmentSlotType, List<ResourceLocation>> tagTest = Maps.newHashMap();

    @Nullable
    public static EquipmentSlotType getType(String type) {
        for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
            if (!slotType.func_188450_d().equals(type)) continue;
            return slotType;
        }
        return null;
    }

    public void addTest(String name) {
        Matcher matcherId = ID_PRE_REG.matcher(name);
        if (matcherId.find()) {
            EquipmentSlotType type = ConditionArmor.getType(matcherId.group(1));
            if (type == null) {
                return;
            }
            String id = matcherId.group(2);
            if (!ResourceLocation.func_217855_b((String)id)) {
                return;
            }
            ResourceLocation res = new ResourceLocation(id);
            if (this.idTest.containsKey(type)) {
                this.idTest.get(type).add(res);
            } else {
                this.idTest.put(type, Lists.newArrayList((Object[])new ResourceLocation[]{res}));
            }
            return;
        }
        Matcher matcherTag = TAG_PRE_REG.matcher(name);
        if (matcherTag.find()) {
            EquipmentSlotType type = ConditionArmor.getType(matcherTag.group(1));
            if (type == null) {
                return;
            }
            String id = matcherTag.group(2);
            if (!ResourceLocation.func_217855_b((String)id)) {
                return;
            }
            ResourceLocation res = new ResourceLocation(id);
            ITag tag = ItemTags.func_199903_a().func_199910_a(res);
            if (tag == null) {
                return;
            }
            if (this.tagTest.containsKey(type)) {
                this.tagTest.get(type).add(res);
            } else {
                this.tagTest.put(type, Lists.newArrayList((Object[])new ResourceLocation[]{res}));
            }
        }
    }

    public String doTest(EntityMaid maid, EquipmentSlotType slot) {
        ItemStack item = maid.func_184582_a(slot);
        if (item.func_190926_b()) {
            return EMPTY;
        }
        String result = this.doIdTest(maid, slot);
        if (result.isEmpty()) {
            return this.doTagTest(maid, slot);
        }
        return result;
    }

    private String doIdTest(EntityMaid maid, EquipmentSlotType slot) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        if (!this.idTest.containsKey(slot) || this.idTest.get(slot).isEmpty()) {
            return EMPTY;
        }
        List<ResourceLocation> idListTest = this.idTest.get(slot);
        ItemStack item = maid.func_184582_a(slot);
        ResourceLocation registryName = item.func_77973_b().getRegistryName();
        if (registryName == null) {
            return EMPTY;
        }
        if (idListTest.contains(registryName)) {
            return slot.func_188450_d() + "$" + registryName;
        }
        return EMPTY;
    }

    private String doTagTest(EntityMaid maid, EquipmentSlotType slot) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        if (!this.tagTest.containsKey(slot) || this.tagTest.get(slot).isEmpty()) {
            return EMPTY;
        }
        List<ResourceLocation> tagListTest = this.tagTest.get(slot);
        Item item = maid.func_184582_a(slot).func_77973_b();
        return tagListTest.stream().filter(itemTagKey -> {
            ITag tag = ItemTags.func_199903_a().func_199910_a(itemTagKey);
            if (tag != null) {
                return tag.func_230235_a_((Object)item);
            }
            return false;
        }).findFirst().map(itemTagKey -> slot.func_188450_d() + "#" + itemTagKey).orElse(EMPTY);
    }
}

