/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;

public class ConditionalHold {
    private static final String EMPTY = "";
    private final int preSize;
    private final String idPre;
    private final String tagPre;
    private final List<ResourceLocation> idTest = Lists.newArrayList();
    private final List<ResourceLocation> tagTest = Lists.newArrayList();

    public ConditionalHold(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            this.idPre = "hold_mainhand$";
            this.tagPre = "hold_mainhand#";
            this.preSize = 14;
        } else {
            this.idPre = "hold_offhand$";
            this.tagPre = "hold_offhand#";
            this.preSize = 13;
        }
    }

    public void addTest(String name) {
        if (name.length() <= this.preSize) {
            return;
        }
        String substring = name.substring(this.preSize);
        if (name.startsWith(this.idPre) && ResourceLocation.func_217855_b((String)substring)) {
            this.idTest.add(new ResourceLocation(substring));
        }
        if (name.startsWith(this.tagPre) && ResourceLocation.func_217855_b((String)substring)) {
            ResourceLocation res = new ResourceLocation(substring);
            ITag tag = ItemTags.func_199903_a().func_199910_a(res);
            if (tag == null) {
                return;
            }
            this.tagTest.add(res);
        }
    }

    public String doTest(EntityMaid maid, Hand hand) {
        if (maid.func_184586_b(hand).func_190926_b()) {
            return EMPTY;
        }
        String result = this.doIdTest(maid, hand);
        if (result.isEmpty()) {
            return this.doTagTest(maid, hand);
        }
        return result;
    }

    private String doIdTest(EntityMaid maid, Hand hand) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemInHand = maid.func_184586_b(hand);
        ResourceLocation registryName = itemInHand.func_77973_b().getRegistryName();
        if (registryName == null) {
            return EMPTY;
        }
        if (this.idTest.contains(registryName)) {
            return this.idPre + registryName;
        }
        return EMPTY;
    }

    private String doTagTest(EntityMaid maid, Hand hand) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        Item itemInHand = maid.func_184586_b(hand).func_77973_b();
        return this.tagTest.stream().filter(itemTagKey -> {
            ITag tag = ItemTags.func_199903_a().func_199910_a(itemTagKey);
            if (tag != null) {
                return tag.func_230235_a_((Object)itemInHand);
            }
            return false;
        }).findFirst().map(itemTagKey -> this.tagPre + itemTagKey).orElse(EMPTY);
    }
}

