/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;

public class ConditionalSwing {
    private static final String ID_PRE = "swing$";
    private static final String TAG_PRE = "swing#";
    private static final String EMPTY = "";
    private static final int PRE_SIZE = 6;
    private final List<ResourceLocation> idTest = Lists.newArrayList();
    private final List<ResourceLocation> tagTest = Lists.newArrayList();

    public void addTest(String name) {
        if (name.length() <= 6) {
            return;
        }
        String substring = name.substring(6);
        if (name.startsWith(ID_PRE) && ResourceLocation.func_217855_b((String)substring)) {
            this.idTest.add(new ResourceLocation(name.substring(6)));
        }
        if (name.startsWith(TAG_PRE) && ResourceLocation.func_217855_b((String)substring)) {
            ResourceLocation res = new ResourceLocation(substring);
            ITag tag = ItemTags.func_199903_a().func_199910_a(res);
            if (tag == null) {
                return;
            }
            this.tagTest.add(res);
        }
    }

    public String doTest(EntityMaid maid, Hand hand) {
        if (maid.func_184586_b(hand).func_190926_b()) {
            return EMPTY;
        }
        String result = this.doIdTest(maid, hand);
        if (result.isEmpty()) {
            return this.doTagTest(maid, hand);
        }
        return result;
    }

    private String doIdTest(EntityMaid maid, Hand hand) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemInHand = maid.func_184586_b(hand);
        ResourceLocation registryName = itemInHand.func_77973_b().getRegistryName();
        if (registryName == null) {
            return EMPTY;
        }
        if (this.idTest.contains(registryName)) {
            return ID_PRE + registryName;
        }
        return EMPTY;
    }

    private String doTagTest(EntityMaid maid, Hand hand) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        Item itemInHand = maid.func_184586_b(hand).func_77973_b();
        return this.tagTest.stream().filter(itemTagKey -> {
            ITag tag = ItemTags.func_199903_a().func_199910_a(itemTagKey);
            if (tag != null) {
                return tag.func_230235_a_((Object)itemInHand);
            }
            return false;
        }).findFirst().map(itemTagKey -> TAG_PRE + itemTagKey).orElse(EMPTY);
    }
}

