/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;

public class ConditionalUse {
    private static final String EMPTY = "";
    private final int preSize;
    private final String idPre;
    private final String tagPre;
    private final String extraPre;
    private final List<ResourceLocation> idTest = Lists.newArrayList();
    private final List<ResourceLocation> tagTest = Lists.newArrayList();
    private final List<UseAction> extraTest = Lists.newArrayList();

    public ConditionalUse(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            this.idPre = "use_mainhand$";
            this.tagPre = "use_mainhand#";
            this.extraPre = "use_mainhand:";
            this.preSize = 13;
        } else {
            this.idPre = "use_offhand$";
            this.tagPre = "use_offhand#";
            this.extraPre = "use_offhand:";
            this.preSize = 12;
        }
    }

    public void addTest(String name) {
        if (name.length() <= this.preSize) {
            return;
        }
        String substring = name.substring(this.preSize);
        if (name.startsWith(this.idPre) && ResourceLocation.func_217855_b((String)substring)) {
            this.idTest.add(new ResourceLocation(substring));
        }
        if (name.startsWith(this.tagPre) && ResourceLocation.func_217855_b((String)substring)) {
            ResourceLocation res = new ResourceLocation(substring);
            ITag tag = ItemTags.func_199903_a().func_199910_a(res);
            if (tag == null) {
                return;
            }
            this.tagTest.add(res);
        }
        if (name.startsWith(this.extraPre)) {
            if (substring.equals(UseAction.NONE.name().toLowerCase(Locale.US))) {
                return;
            }
            Arrays.stream(UseAction.values()).filter(a -> a.name().toLowerCase(Locale.US).equals(substring)).findFirst().ifPresent(this.extraTest::add);
        }
    }

    public String doTest(EntityMaid maid, Hand hand) {
        if (maid.func_184586_b(hand).func_190926_b()) {
            return EMPTY;
        }
        String result = this.doIdTest(maid, hand);
        if (result.isEmpty()) {
            result = this.doTagTest(maid, hand);
            if (result.isEmpty()) {
                return this.doExtraTest(maid, hand);
            }
            return result;
        }
        return result;
    }

    private String doIdTest(EntityMaid maid, Hand hand) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemInHand = maid.func_184586_b(hand);
        ResourceLocation registryName = itemInHand.func_77973_b().getRegistryName();
        if (registryName == null) {
            return EMPTY;
        }
        if (this.idTest.contains(registryName)) {
            return this.idPre + registryName;
        }
        return EMPTY;
    }

    private String doTagTest(EntityMaid maid, Hand hand) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        Item itemInHand = maid.func_184586_b(hand).func_77973_b();
        return this.tagTest.stream().filter(itemTagKey -> {
            ITag tag = ItemTags.func_199903_a().func_199910_a(itemTagKey);
            if (tag != null) {
                return tag.func_230235_a_((Object)itemInHand);
            }
            return false;
        }).findFirst().map(itemTagKey -> this.tagPre + itemTagKey).orElse(EMPTY);
    }

    private String doExtraTest(EntityMaid maid, Hand hand) {
        if (this.extraTest.isEmpty()) {
            return EMPTY;
        }
        UseAction anim = maid.func_184586_b(hand).func_77975_n();
        if (this.extraTest.contains(anim)) {
            return this.extraPre + anim.name().toLowerCase(Locale.US);
        }
        return EMPTY;
    }
}

