/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.inner;

import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.IAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.InnerAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.HashMap;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;

public final class PlayerMaidAnimation {
    private static final float[] FIXED_HAND_ROTATION = new float[]{0.0f, 0.0f, 0.0f};

    public static void init() {
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/player/arm/default.js"), PlayerMaidAnimation.getPlayerArmDefault());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/maid/player/sit/default.js"), PlayerMaidAnimation.getPlayerSitDefault());
    }

    public static IAnimation<EntityMaid> getPlayerArmDefault() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                float[] rotation;
                ModelRendererWrapper armLeft = modelMap.get("armLeft");
                ModelRendererWrapper armRight = modelMap.get("armRight");
                double f1 = 1.0 - Math.pow(1.0 - (double)maid.field_70733_aJ, 4.0);
                double f2 = Math.sin(f1 * Math.PI);
                double f3 = Math.sin((double)maid.field_70733_aJ * Math.PI) * -0.7 * 0.75;
                if (armLeft != null) {
                    if (maid.isSitInJoyBlock()) {
                        armLeft.setRotateAngleX(-1.8f);
                    } else if (PlayerMaidAnimation.isHoldTrolley()) {
                        armLeft.setRotateAngleX(0.5f);
                        armLeft.setRotateAngleY(0.0f);
                        armLeft.setRotateAngleZ(-0.395f);
                    } else if (PlayerMaidAnimation.isHoldVehicle()) {
                        rotation = PlayerMaidAnimation.getLeftHandRotation();
                        armLeft.setRotateAngleX(rotation[0]);
                        armLeft.setRotateAngleY(rotation[1]);
                        armLeft.setRotateAngleZ(rotation[2]);
                    } else {
                        armLeft.setRotateAngleX((float)(-Math.cos((double)limbSwing * 0.67) * 0.7 * (double)limbSwingAmount));
                        armLeft.setRotateAngleY(0.0f);
                        armLeft.setRotateAngleZ((float)(Math.cos((double)ageInTicks * 0.05) * 0.025 - 0.05));
                        if ((double)maid.field_70733_aJ > 0.0 && PlayerMaidAnimation.isSwingLeftHand(maid)) {
                            armLeft.setRotateAngleX((float)((double)armLeft.getRotateAngleX() - (f2 * 1.2 + f3)));
                            armLeft.setRotateAngleZ(armLeft.getRotateAngleZ() + (float)(Math.sin((double)maid.field_70733_aJ * Math.PI) * -0.4));
                        }
                    }
                }
                if (armRight != null) {
                    if (maid.isSitInJoyBlock()) {
                        armRight.setRotateAngleX(-1.8f);
                    } else if (PlayerMaidAnimation.isHoldVehicle()) {
                        rotation = PlayerMaidAnimation.getRightHandRotation();
                        armRight.setRotateAngleX(rotation[0]);
                        armRight.setRotateAngleY(rotation[1]);
                        armRight.setRotateAngleZ(rotation[2]);
                    } else {
                        armRight.setRotateAngleX((float)(Math.cos((double)limbSwing * 0.67) * 0.7 * (double)limbSwingAmount));
                        armRight.setRotateAngleY(0.0f);
                        armRight.setRotateAngleZ((float)(-Math.cos((double)ageInTicks * 0.05) * 0.025 + 0.05));
                        if ((double)maid.field_70733_aJ > 0.0 && !PlayerMaidAnimation.isSwingLeftHand(maid)) {
                            armRight.setRotateAngleX((float)((double)armRight.getRotateAngleX() - (f2 * 1.2 + f3)));
                            armRight.setRotateAngleZ((float)((double)armRight.getRotateAngleZ() + Math.sin((double)maid.field_70733_aJ * Math.PI) * -0.4));
                        }
                    }
                }
            }
        };
    }

    public static IAnimation<EntityMaid> getPlayerSitDefault() {
        return new IAnimation<EntityMaid>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityMaid maid, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper head = modelMap.get("head");
                ModelRendererWrapper legLeft = modelMap.get("legLeft");
                ModelRendererWrapper legRight = modelMap.get("legRight");
                ModelRendererWrapper armLeft = modelMap.get("armLeft");
                ModelRendererWrapper armRight = modelMap.get("armRight");
                if (head != null) {
                    head.setOffsetY(0.0f);
                }
                if (PlayerMaidAnimation.isPassengerMarisaBroom()) {
                    PlayerMaidAnimation.playerRidingBroomPosture(head, armLeft, armRight, legLeft, legRight);
                } else if (maid.func_184218_aH()) {
                    PlayerMaidAnimation.playerRidingPosture(legLeft, legRight);
                } else if (maid.func_233684_eK_()) {
                    PlayerMaidAnimation.playerSittingPosture(armLeft, armRight, legLeft, legRight);
                }
            }
        };
    }

    private static void playerRidingPosture(ModelRendererWrapper legLeft, ModelRendererWrapper legRight) {
        if (legLeft != null) {
            legLeft.setRotateAngleX(-1.4f);
            legLeft.setRotateAngleY(-0.4f);
        }
        if (legRight != null) {
            legRight.setRotateAngleX(-1.4f);
            legRight.setRotateAngleY(0.4f);
        }
        GlWrapper.translate(0.0, 0.3, 0.0);
    }

    private static void playerSittingPosture(ModelRendererWrapper armLeft, ModelRendererWrapper armRight, ModelRendererWrapper legLeft, ModelRendererWrapper legRight) {
        if (armLeft != null) {
            armLeft.setRotateAngleX(-0.798f);
            armLeft.setRotateAngleZ(0.274f);
        }
        if (armRight != null) {
            armRight.setRotateAngleX(-0.798f);
            armRight.setRotateAngleZ(-0.274f);
        }
        PlayerMaidAnimation.ridingPosture(legLeft, legRight);
    }

    private static void playerRidingBroomPosture(ModelRendererWrapper head, ModelRendererWrapper armLeft, ModelRendererWrapper armRight, ModelRendererWrapper legLeft, ModelRendererWrapper legRight) {
        PlayerMaidAnimation.sittingPosture(armLeft, armRight, legLeft, legRight);
        if (head != null) {
            head.setRotateAngleX((float)((double)head.getRotateAngleX() - 0.5235987755982988));
            head.setOffsetY(0.0625f);
        }
        GlWrapper.rotate(30.0, 1.0, 0.0, 0.0);
        GlWrapper.translate(0.0, -0.45, -0.3);
    }

    private static void ridingPosture(ModelRendererWrapper legLeft, ModelRendererWrapper legRight) {
        if (legLeft != null) {
            legLeft.setRotateAngleX(-1.134f);
            legLeft.setRotateAngleZ(-0.262f);
        }
        if (legRight != null) {
            legRight.setRotateAngleX(-1.134f);
            legRight.setRotateAngleZ(0.262f);
        }
        GlWrapper.translate(0.0, 0.3, 0.0);
    }

    private static void sittingPosture(ModelRendererWrapper armLeft, ModelRendererWrapper armRight, ModelRendererWrapper legLeft, ModelRendererWrapper legRight) {
        if (armLeft != null) {
            armLeft.setRotateAngleX(-0.798f);
            armLeft.setRotateAngleZ(0.274f);
        }
        if (armRight != null) {
            armRight.setRotateAngleX(-0.798f);
            armRight.setRotateAngleZ(-0.274f);
        }
        PlayerMaidAnimation.ridingPosture(legLeft, legRight);
    }

    private static boolean isSwingLeftHand(EntityMaid maid) {
        return maid.field_184622_au == Hand.OFF_HAND;
    }

    @Deprecated
    private static boolean isPassengerMarisaBroom() {
        return false;
    }

    @Deprecated
    private static boolean isHoldTrolley() {
        return false;
    }

    @Deprecated
    private static boolean isHoldVehicle() {
        return false;
    }

    @Deprecated
    private static float[] getLeftHandRotation() {
        return FIXED_HAND_ROTATION;
    }

    @Deprecated
    private static float[] getRightHandRotation() {
        return FIXED_HAND_ROTATION;
    }
}

