/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.script;

import com.github.tartaricacid.touhoulittlemaid.api.animation.IMaidData;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.WorldWrapper;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;

public final class EntityMaidWrapper
implements IMaidData {
    private final WorldWrapper world = new WorldWrapper();
    private final float[] handRotation = new float[]{0.0f, 0.0f, 0.0f};
    private float swingProgress;
    private boolean isRiding;
    private EntityMaid maid;

    public void setData(EntityMaid maid, float swingProgress, boolean isRiding) {
        this.maid = maid;
        this.swingProgress = swingProgress;
        this.isRiding = isRiding;
        this.world.setData(maid.field_70170_p);
    }

    public void clearData() {
        this.maid = null;
        this.world.clearData();
    }

    @Override
    public WorldWrapper getWorld() {
        return this.world;
    }

    @Override
    public String getTask() {
        return this.maid.getTask().getUid().toString();
    }

    @Override
    public boolean hasHelmet() {
        return !this.maid.func_184582_a(EquipmentSlotType.HEAD).func_190926_b();
    }

    @Override
    public String getHelmet() {
        ResourceLocation res = this.maid.func_184582_a(EquipmentSlotType.HEAD).func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasChestPlate() {
        return !this.maid.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
    }

    @Override
    public String getChestPlate() {
        ResourceLocation res = this.maid.func_184582_a(EquipmentSlotType.CHEST).func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasLeggings() {
        return !this.maid.func_184582_a(EquipmentSlotType.LEGS).func_190926_b();
    }

    @Override
    public String getLeggings() {
        ResourceLocation res = this.maid.func_184582_a(EquipmentSlotType.LEGS).func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasBoots() {
        return !this.maid.func_184582_a(EquipmentSlotType.FEET).func_190926_b();
    }

    @Override
    public String getBoots() {
        ResourceLocation res = this.maid.func_184582_a(EquipmentSlotType.FEET).func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasItemMainhand() {
        return this.maid.func_184614_ca().func_190926_b();
    }

    @Override
    public String getItemMainhand() {
        ResourceLocation res = this.maid.func_184614_ca().func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean hasItemOffhand() {
        return this.maid.func_184592_cb().func_190926_b();
    }

    @Override
    public String getItemOffhand() {
        ResourceLocation res = this.maid.func_184592_cb().func_77973_b().getRegistryName();
        if (res != null) {
            return res.toString();
        }
        return "";
    }

    @Override
    public boolean isBegging() {
        return this.maid.isBegging();
    }

    @Override
    public boolean isSwingingArms() {
        return this.maid.isSwingingArms();
    }

    @Override
    public boolean isRiding() {
        return this.isRiding;
    }

    @Override
    public boolean isSitting() {
        return this.maid.func_233684_eK_();
    }

    @Override
    public boolean hasBackpack() {
        return this.maid.hasBackpack();
    }

    @Override
    @Deprecated
    public int getBackpackLevel() {
        return 0;
    }

    @Override
    public boolean inWater() {
        return this.maid.func_70090_H();
    }

    @Override
    public boolean inRain() {
        return this.maid.field_70170_p.func_175727_C(this.maid.func_233580_cy_());
    }

    @Override
    public boolean isSwingLeftHand() {
        return this.maid.field_184622_au == Hand.OFF_HAND;
    }

    @Override
    public float getSwingProgress() {
        return this.swingProgress;
    }

    @Override
    public float getHealth() {
        return this.maid.func_110143_aJ();
    }

    @Override
    public float getMaxHealth() {
        return this.maid.func_110138_aP();
    }

    @Override
    public double getArmorValue() {
        return this.maid.func_233637_b_(Attributes.field_233826_i_);
    }

    @Override
    public boolean onHurt() {
        return this.maid.field_70737_aN > 0;
    }

    @Override
    public boolean isSleep() {
        return this.maid.func_70608_bn();
    }

    @Override
    public int getFavorability() {
        return this.maid.getFavorability();
    }

    @Override
    public long getSeed() {
        return Math.abs(this.maid.func_110124_au().getLeastSignificantBits());
    }

    @Override
    public String getAtBiome() {
        ResourceLocation res = BiomeCacheUtil.getCacheBiome((Entity)this.maid).getRegistryName();
        if (res != null) {
            return res.func_110623_a();
        }
        return "";
    }

    @Override
    public boolean isOnGround() {
        return !this.maid.func_233570_aj_();
    }

    @Override
    @Deprecated
    public String getAtBiomeTemp() {
        return this.maid.getAtBiomeTemp();
    }

    @Override
    @Deprecated
    public boolean hasSasimono() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isHoldTrolley() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isRidingMarisaBroom() {
        return false;
    }

    @Override
    public boolean isRidingPlayer() {
        return this.maid.func_184187_bx() instanceof PlayerEntity;
    }

    @Override
    @Deprecated
    public boolean isHoldVehicle() {
        return false;
    }

    @Override
    @Deprecated
    public boolean isPortableAudioPlay() {
        return false;
    }

    @Override
    @Deprecated
    public float[] getLeftHandRotation() {
        return this.handRotation;
    }

    @Override
    @Deprecated
    public float[] getRightHandRotation() {
        return this.handRotation;
    }

    @Override
    @Deprecated
    public int getDim() {
        return this.maid.getDim();
    }
}

