/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.download;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.info.ServerCustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.util.ZipFileCheck;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.ClientLanguageMap;
import net.minecraft.client.resources.Language;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class InfoGetManager {
    private static final String ROOT_URL = "http://tlm.cfpa.team:29434/";
    private static final String INFO_JSON_URL = "http://tlm.cfpa.team:29434/info.json";
    private static final String INFO_JSON_MD5_URL = "http://tlm.cfpa.team:29434/info.json.md5";
    private static final Path ROOT_FOLDER = InfoGetManager.getRootPath();
    private static final Path INFO_JSON_FILE = ROOT_FOLDER.resolve("info.json");
    private static final Path PACK_FOLDER = ROOT_FOLDER.resolve("file");
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_ALL = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_MAID = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_CHAIR = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_SOUND = Lists.newArrayList();
    public static Statue STATUE = Statue.FIRST;

    public static void checkInfoJsonFile() {
        if (!ROOT_FOLDER.toFile().isDirectory()) {
            try {
                Files.createDirectories(ROOT_FOLDER, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
        }
        if (!INFO_JSON_FILE.toFile().isFile()) {
            InfoGetManager.downloadAndReadInfoJsonFile();
        } else {
            try {
                FileInputStream stream = new FileInputStream(INFO_JSON_FILE.toFile());
                InfoGetManager.downloadAndReadInfoJsonFile(DigestUtils.md5Hex((InputStream)stream));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static Path getRootPath() {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71412_D != null) {
            return Paths.get(Minecraft.func_71410_x().field_71412_D.toURI()).resolve("config").resolve("touhou_little_maid");
        }
        return Paths.get("./", new String[0]).resolve("config").resolve("touhou_little_maid");
    }

    private static void downloadAndReadInfoJsonFile() {
        InfoGetManager.downloadAndReadInfoJsonFile(null);
    }

    private static void downloadAndReadInfoJsonFile(@Nullable String md5) {
        Thread thread = new Thread(() -> {
            try {
                File file = INFO_JSON_FILE.toFile();
                if (StringUtils.isNotBlank((CharSequence)md5)) {
                    String md5Remote = IOUtils.toString((URL)new URL(INFO_JSON_MD5_URL), (Charset)StandardCharsets.UTF_8);
                    if (md5Remote.equals(md5)) {
                        TouhouLittleMaid.LOGGER.info("info.json file no update required");
                        STATUE = Statue.NOT_UPDATE;
                    } else {
                        TouhouLittleMaid.LOGGER.info("Downloading info.json file...");
                        FileUtils.copyURLToFile((URL)new URL(INFO_JSON_URL), (File)file, (int)30000, (int)30000);
                        TouhouLittleMaid.LOGGER.info("Downloaded info.json file");
                        STATUE = Statue.UPDATE;
                    }
                } else {
                    TouhouLittleMaid.LOGGER.info("Downloading info.json file...");
                    FileUtils.copyURLToFile((URL)new URL(INFO_JSON_URL), (File)file, (int)30000, (int)30000);
                    TouhouLittleMaid.LOGGER.info("Downloaded info.json file");
                }
                DOWNLOAD_INFO_LIST_ALL = (List)CustomPackLoader.GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), new TypeToken<List<DownloadInfo>>(){}.getType());
                DOWNLOAD_INFO_LIST_ALL.forEach(DownloadInfo::decorate);
                DOWNLOAD_INFO_LIST_ALL.forEach(downloadInfo -> {
                    if (downloadInfo.hasType(DownloadInfo.TypeEnum.MAID)) {
                        DOWNLOAD_INFO_LIST_MAID.add((DownloadInfo)downloadInfo);
                    }
                    if (downloadInfo.hasType(DownloadInfo.TypeEnum.CHAIR)) {
                        DOWNLOAD_INFO_LIST_CHAIR.add((DownloadInfo)downloadInfo);
                    }
                    if (downloadInfo.hasType(DownloadInfo.TypeEnum.SOUND)) {
                        DOWNLOAD_INFO_LIST_SOUND.add((DownloadInfo)downloadInfo);
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "Download-Info-Json-File");
        thread.start();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(InfoGetManager::checkInfoJsonFile);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onResourceReload(TextureStitchEvent.Post event) {
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        Map oldLangData = LanguageMap.func_74808_a().getLanguageData();
        HashMap newLangData = Maps.newHashMap();
        newLangData.putAll(oldLangData);
        for (DownloadInfo info : DOWNLOAD_INFO_LIST_ALL) {
            HashMap<String, String> langMap = info.getLanguage("en_us");
            for (String key : langMap.keySet()) {
                newLangData.put(key, langMap.get(key));
            }
            String currentLanguage = language.getCode();
            HashMap<String, String> currentLangMap = info.getLanguage(currentLanguage);
            if (currentLangMap == null) continue;
            for (String key : currentLangMap.keySet()) {
                newLangData.put(key, currentLangMap.get(key));
            }
        }
        if (LanguageMap.func_74808_a() instanceof ClientLanguageMap) {
            ((ClientLanguageMap)LanguageMap.func_74808_a()).field_239495_c_ = newLangData;
        }
    }

    public static void downloadResourcesPack(DownloadInfo info) {
        Thread thread = new Thread(() -> {
            info.setStatus(DownloadStatus.DOWNLOADING);
            try {
                URL url = new URL(new URL(ROOT_URL), info.getUrl());
                File fileInTlmModel = CustomPackLoader.PACK_FOLDER.resolve(info.getFileName()).toFile();
                File fileInCache = PACK_FOLDER.resolve(info.getFileName()).toFile();
                if (!fileInCache.isFile() || FileUtils.checksumCRC32((File)fileInCache) != info.getChecksum()) {
                    InfoGetManager.sendDownloadMessage((ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.resources_download.state.downloading", new Object[]{info.getFileName()}));
                    StopWatch stopWatch = StopWatch.createStarted();
                    FileUtils.copyURLToFile((URL)url, (File)fileInCache, (int)60000, (int)60000);
                    stopWatch.stop();
                    InfoGetManager.sendDownloadMessage((ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.resources_download.state.downloaded", new Object[]{info.getFileName(), (double)stopWatch.getTime(TimeUnit.MILLISECONDS) / 1000.0}));
                } else {
                    InfoGetManager.sendDownloadMessage((ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.resources_download.state.downloaded", new Object[]{info.getFileName(), 0.943}));
                }
                if (ZipFileCheck.isZipFile(fileInCache)) {
                    Files.copy(fileInCache.toPath(), fileInTlmModel.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    CustomPackLoader.readModelFromZipFile(fileInTlmModel);
                    ServerCustomPackLoader.reloadPacks();
                    info.setStatus(DownloadStatus.DOWNLOADED);
                } else {
                    info.setStatus(DownloadStatus.NOT_DOWNLOAD);
                    TouhouLittleMaid.LOGGER.error("{} file is corrupt and cannot be loaded.", (Object)info.getFileName());
                }
            }
            catch (IOException e) {
                info.setStatus(DownloadStatus.NOT_DOWNLOAD);
                e.printStackTrace();
            }
        }, String.format("Download-Resources-Pack-File-%s", info.getName()));
        thread.start();
    }

    private static void sendDownloadMessage(ITextComponent component) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.func_145747_a(component, Util.field_240973_b_);
        }
    }

    public static List<DownloadInfo> getTypedDownloadInfoList(DownloadInfo.TypeEnum typeEnum) {
        switch (typeEnum) {
            case CHAIR: {
                return DOWNLOAD_INFO_LIST_CHAIR;
            }
            case SOUND: {
                return DOWNLOAD_INFO_LIST_SOUND;
            }
        }
        return DOWNLOAD_INFO_LIST_MAID;
    }

    public static enum Statue {
        FIRST,
        UPDATE,
        NOT_UPDATE;

    }
}

