/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.entity;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationManager;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager.AnimationData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager.AnimationFactory;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.GeckoLibUtil;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;

public class GeckoMaidEntity
implements IAnimatable {
    private static final ResourceLocation GECKO_DEFAULT_ID = new ResourceLocation("touhou_little_maid", "fox_miko");
    private final AnimationFactory factory = GeckoLibUtil.createFactory(this, true);
    private EntityMaid maid = null;
    private MaidModelInfo mainInfo;

    @Override
    public void registerControllers(AnimationData data) {
        String animationName;
        String controllerName;
        int i;
        AnimationManager manager = AnimationManager.getInstance();
        for (i = 0; i < 8; ++i) {
            controllerName = String.format("pre_parallel_%d_controller", i);
            animationName = String.format("pre_parallel%d", i);
            data.addAnimationController(new AnimationController<GeckoMaidEntity>(this, controllerName, 0.0f, e -> manager.predicateParallel(e, animationName)));
        }
        data.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "main", 2.0f, manager::predicateMain));
        data.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "hold_offhand", 0.0f, manager::predicateOffhandHold));
        data.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "hold_mainhand", 0.0f, manager::predicateMainhandHold));
        data.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "swing", 2.0f, manager::predicateSwing));
        data.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "use", 2.0f, manager::predicateUse));
        data.addAnimationController(new AnimationController<GeckoMaidEntity>(this, "beg", 2.0f, manager::predicateBeg));
        for (i = 0; i < 8; ++i) {
            controllerName = String.format("parallel_%d_controller", i);
            animationName = String.format("parallel%d", i);
            data.addAnimationController(new AnimationController<GeckoMaidEntity>(this, controllerName, 0.0f, e -> manager.predicateParallel(e, animationName)));
        }
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
            String controllerName2 = String.format("%s_controller", slot.func_188450_d());
            data.addAnimationController(new AnimationController<GeckoMaidEntity>(this, controllerName2, 0.0f, e -> manager.predicateArmor(e, slot)));
        }
    }

    public ResourceLocation getModel() {
        if (GeckoLibCache.getInstance().getGeoModels().containsKey(this.mainInfo.getModelId())) {
            return this.mainInfo.getModelId();
        }
        return GECKO_DEFAULT_ID;
    }

    public ResourceLocation getTexture() {
        return this.mainInfo.getTexture();
    }

    public ResourceLocation getAnimation() {
        if (GeckoLibCache.getInstance().getAnimations().containsKey(this.mainInfo.getModelId())) {
            return this.mainInfo.getModelId();
        }
        return GECKO_DEFAULT_ID;
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    public void setMaid(EntityMaid maid, MaidModelInfo info) {
        this.maid = maid;
        this.mainInfo = info;
    }
}

