/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT})
public class MaidAreaRenderEvent {
    private static final Cache<Integer, SchedulePos> CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    @SubscribeEvent
    public static void onRender(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        Vector3d camera = mc.field_71460_t.func_215316_n().func_216785_c().func_216371_e();
        MatrixStack poseStack = event.getMatrixStack();
        Iterator iterator = CACHE.asMap().keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            SchedulePos pos = (SchedulePos)CACHE.getIfPresent((Object)id);
            if (pos == null) continue;
            Entity entity = mc.field_71441_e.func_73045_a(id);
            if (!(entity instanceof EntityMaid)) {
                return;
            }
            EntityMaid maid = (EntityMaid)entity;
            ResourceLocation dimension = pos.getDimension();
            if (!mc.field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)dimension)) continue;
            MaidAreaRenderEvent.renderPos(pos.getWorkPos(), pos.getIdlePos(), pos.getSleepPos(), camera, poseStack, mc, maid, (PlayerEntity)mc.field_71439_g);
        }
    }

    private static void renderPos(@Nullable BlockPos workPos, @Nullable BlockPos idlePos, @Nullable BlockPos resetPos, Vector3d camera, MatrixStack poseStack, Minecraft mc, EntityMaid maid, PlayerEntity player) {
        Vector3d prePos;
        String text;
        Vector3d textPos;
        IVertexBuilder buffer;
        double radius;
        Vector3d centerPos;
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.0, 1.0, 0.0);
        BlockPos restrictCenter = maid.func_213384_dI();
        Vector3d restrictPos = camera.func_72441_c((double)restrictCenter.func_177958_n() + 0.5, (double)restrictCenter.func_177956_o() + 0.5, (double)restrictCenter.func_177952_p() + 0.5);
        if (!maid.isHomeModeEnable()) {
            restrictPos = camera.func_178787_e(player.func_213303_ch());
        }
        Vector3d maidPos = camera.func_178787_e(maid.func_213303_ch());
        RenderHelper.renderLine(poseStack, mc.func_228019_au_().func_228487_b_().getBuffer((RenderType)RenderType.field_228614_Q_), restrictPos, maidPos, 1.0f, 0.2f, 0.2f);
        AxisAlignedBB aabb = maid.func_174813_aQ().func_72317_d(0.0, -1.0, 0.0).func_191194_a(camera);
        RenderHelper.addChainedFilledBoxVertices(poseStack, mc.func_228019_au_().func_228487_b_(), aabb, 0.8f, 0.8f, 0.2f, 0.75f);
        if (workPos != null) {
            centerPos = camera.func_72441_c((double)workPos.func_177958_n() + 0.5, (double)workPos.func_177956_o() + 0.5, (double)workPos.func_177952_p() + 0.5);
            radius = (double)((Integer)MaidConfig.MAID_WORK_RANGE.get()).intValue() + 0.1;
            buffer = mc.func_228019_au_().func_228487_b_().getBuffer((RenderType)RenderType.field_228614_Q_);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 1.0f, 0.0f, 0.0f);
            textPos = new Vector3d((double)workPos.func_177958_n() + 0.5, (double)(workPos.func_177956_o() + 2), (double)workPos.func_177952_p() + 0.5);
            text = I18n.func_135052_a((String)"message.touhou_little_maid.kappa_compass.work_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.field_72450_a, textPos.field_72448_b, textPos.field_72449_c, 0xFF1111, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.field_72450_a, textPos.field_72448_b, textPos.field_72449_c, 0xFF1111, 0.15f, true, 5.0f, false);
        }
        if (idlePos != null) {
            centerPos = camera.func_72441_c((double)idlePos.func_177958_n() + 0.5, (double)idlePos.func_177956_o() + 0.5, (double)idlePos.func_177952_p() + 0.5);
            radius = ((Integer)MaidConfig.MAID_IDLE_RANGE.get()).intValue();
            buffer = mc.func_228019_au_().func_228487_b_().getBuffer((RenderType)RenderType.field_228614_Q_);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 0.0f, 1.0f, 0.0f);
            textPos = new Vector3d((double)idlePos.func_177958_n() + 0.5, (double)(idlePos.func_177956_o() + 2), (double)idlePos.func_177952_p() + 0.5);
            if (idlePos.equals((Object)workPos)) {
                textPos = textPos.func_72441_c(0.0, 1.0, 0.0);
            } else if (workPos != null) {
                prePos = camera.func_72441_c((double)workPos.func_177958_n() + 0.5, (double)workPos.func_177956_o() + 0.5, (double)workPos.func_177952_p() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            text = I18n.func_135052_a((String)"message.touhou_little_maid.kappa_compass.idle_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.field_72450_a, textPos.field_72448_b, textPos.field_72449_c, 0x11FF11, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.field_72450_a, textPos.field_72448_b, textPos.field_72449_c, 0x11FF11, 0.15f, true, 5.0f, false);
        }
        if (resetPos != null) {
            centerPos = camera.func_72441_c((double)resetPos.func_177958_n() + 0.5, (double)resetPos.func_177956_o() + 0.5, (double)resetPos.func_177952_p() + 0.5);
            radius = (double)((Integer)MaidConfig.MAID_SLEEP_RANGE.get()).intValue() - 0.1;
            buffer = mc.func_228019_au_().func_228487_b_().getBuffer((RenderType)RenderType.field_228614_Q_);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 0.0f, 0.0f, 1.0f);
            textPos = new Vector3d((double)resetPos.func_177958_n() + 0.5, (double)(resetPos.func_177956_o() + 2), (double)resetPos.func_177952_p() + 0.5);
            if (resetPos.equals((Object)idlePos)) {
                textPos = textPos.func_72441_c(0.0, 2.0, 0.0);
            } else if (idlePos != null && workPos != null) {
                prePos = camera.func_72441_c((double)idlePos.func_177958_n() + 0.5, (double)idlePos.func_177956_o() + 0.5, (double)idlePos.func_177952_p() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                prePos = camera.func_72441_c((double)workPos.func_177958_n() + 0.5, (double)workPos.func_177956_o() + 0.5, (double)workPos.func_177952_p() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            text = I18n.func_135052_a((String)"message.touhou_little_maid.kappa_compass.sleep_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.field_72450_a, textPos.field_72448_b, textPos.field_72449_c, 0x1111FF, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.field_72450_a, textPos.field_72448_b, textPos.field_72449_c, 0x1111FF, 0.15f, true, 5.0f, false);
        }
        poseStack.func_227865_b_();
    }

    public static void addSchedulePos(int id, SchedulePos pos) {
        CACHE.put((Object)id, (Object)pos);
    }
}

