/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.item.ItemFoxScroll;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT})
public class ScrollRenderEvent {
    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && player.func_184614_ca().func_77973_b() instanceof ItemFoxScroll) {
            Pair<String, BlockPos> info = ItemFoxScroll.getTrackInfo(player.func_184614_ca());
            if (info == null) {
                return;
            }
            String dimension = (String)info.getLeft();
            Vector3d trackVec = new Vector3d((double)((BlockPos)info.getRight()).func_177958_n(), (double)((BlockPos)info.getRight()).func_177956_o(), (double)((BlockPos)info.getRight()).func_177952_p());
            if (!dimension.equals(player.field_70170_p.func_234923_W_().func_240901_a_().toString())) {
                return;
            }
            Vector3d playerVec = player.func_213303_ch();
            double actualDistance = playerVec.func_72438_d(trackVec);
            if (actualDistance < 5.0) {
                return;
            }
            double viewDistance = actualDistance;
            double maxRenderDistance = mc.field_71474_y.field_151451_c * 16;
            if (actualDistance > maxRenderDistance) {
                Vector3d delta = trackVec.func_178788_d(playerVec).func_72432_b();
                trackVec = playerVec.func_72441_c(delta.field_72450_a * maxRenderDistance, delta.field_72448_b * maxRenderDistance, delta.field_72449_c * maxRenderDistance);
                viewDistance = maxRenderDistance;
            }
            float scale = 0.02f * (((float)viewDistance + 4.0f) / 3.0f);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderHelper.renderFloatingText(event.getMatrixStack(), Math.round(actualDistance) + " m", trackVec, 0xFF8800, scale, -17.0f);
            RenderHelper.renderFloatingText(event.getMatrixStack(), "\u25bc", trackVec, 0xFF0000, scale * 1.2f, -5.0f);
        }
    }
}

