/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.BeaconEffectButton;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetBeaconOverflowMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.StorageAndTakePowerMessage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class MaidBeaconGui
extends Screen {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/maid_beacon.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private final TileEntityMaidBeacon beacon;
    protected int imageWidth = 300;
    protected int imageHeight = 113;
    protected int leftPos;
    protected int topPos;
    private boolean overflowDelete;
    private int potionIndex;

    public MaidBeaconGui(TileEntityMaidBeacon beacon) {
        super((ITextComponent)new StringTextComponent("Maid Beacon GUI"));
        this.beacon = beacon;
        this.overflowDelete = beacon.isOverflowDelete();
        this.potionIndex = beacon.getPotionIndex();
    }

    protected void func_231160_c_() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.leftPos = (this.field_230708_k_ - this.imageWidth) / 2;
        this.topPos = (this.field_230709_l_ - this.imageHeight) / 2;
        this.addEffectButton(this.leftPos + 146, 26, this.topPos + 19);
        this.addStorageAndTakeButton();
        this.func_230480_a_((Widget)new Button(this.leftPos + 118, this.topPos + 94, 154, 20, (ITextComponent)this.getOverflowDeleteButtonText(this.overflowDelete), b -> {
            this.overflowDelete = !this.overflowDelete;
            NetworkHandler.CHANNEL.sendToServer((Object)new SetBeaconOverflowMessage(this.beacon.func_174877_v(), this.overflowDelete));
            this.func_231160_c_();
        }));
    }

    private void addStorageAndTakeButton() {
        this.func_230480_a_((Widget)new Button(this.leftPos + 118, this.topPos + 72, 76, 20, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.maid_beacon.add_one"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new StorageAndTakePowerMessage(this.beacon.func_174877_v(), 1.0f, true))));
        this.func_230480_a_((Widget)new Button(this.leftPos + 196, this.topPos + 72, 76, 20, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.maid_beacon.min_one"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new StorageAndTakePowerMessage(this.beacon.func_174877_v(), 1.0f, false))));
    }

    private void addEffectButton(int start, int spacing, int y) {
        this.func_230480_a_((Widget)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.SPEED, start, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.SPEED.ordinal() : -1;
            this.func_231160_c_();
        }));
        this.func_230480_a_((Widget)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.FIRE_RESISTANCE, start + spacing, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.FIRE_RESISTANCE.ordinal() : -1;
            this.func_231160_c_();
        }));
        this.func_230480_a_((Widget)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.STRENGTH, start + spacing * 2, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.STRENGTH.ordinal() : -1;
            this.func_231160_c_();
        }));
        this.func_230480_a_((Widget)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.RESISTANCE, start + spacing * 3, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.RESISTANCE.ordinal() : -1;
            this.func_231160_c_();
        }));
        this.func_230480_a_((Widget)new BeaconEffectButton(TileEntityMaidBeacon.BeaconEffect.REGENERATION, start + spacing * 4, y, this.potionIndex, this.beacon, isStateTriggered -> {
            this.potionIndex = isStateTriggered != false ? TileEntityMaidBeacon.BeaconEffect.REGENERATION.ordinal() : -1;
            this.func_231160_c_();
        }));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.getMinecraft().field_71446_o.func_110577_a(BG);
        this.func_238474_b_(matrixStack, this.leftPos, this.topPos + 2, 0, 0, 142, 111);
        this.func_238474_b_(matrixStack, this.leftPos + 118, this.topPos + 1, 44, 111, 154, 15);
        this.func_238474_b_(matrixStack, this.leftPos + 224, this.topPos + 44, 44, 126, 12, 12);
        this.func_238474_b_(matrixStack, this.leftPos + 224, this.topPos + 58, 44, 138, 12, 12);
        this.func_238474_b_(matrixStack, this.leftPos + 146, this.topPos + 46, 58, 128, 74, 9);
        this.func_238474_b_(matrixStack, this.leftPos + 146, this.topPos + 59, 58, 128, 74, 9);
        float percent = this.beacon.getStoragePower() / this.beacon.getMaxStorage();
        this.func_238474_b_(matrixStack, this.leftPos + 146, this.topPos + 48, 58, 138, (int)(74.0f * percent), 5);
        this.renderPlayerPower(matrixStack);
        MaidBeaconGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)DECIMAL_FORMAT.format(this.beacon.getStoragePower()), (int)(this.leftPos + 240), (int)(this.topPos + 46), (int)0xFFFFFF);
        if (this.potionIndex == -1) {
            this.drawCenteredStringNoShadow(matrixStack, this.field_230712_o_, I18n.func_135052_a((String)"gui.touhou_little_maid.maid_beacon.cost_power", (Object[])new Object[]{DECIMAL_FORMAT.format(0L)}), this.leftPos + 195, this.topPos + 5, (int)TextFormatting.DARK_GRAY.func_211163_e());
        } else {
            this.drawCenteredStringNoShadow(matrixStack, this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.touhou_little_maid.maid_beacon.cost_power", new Object[]{DECIMAL_FORMAT.format(this.beacon.getEffectCost() * 900.0f)}).func_240699_a_(TextFormatting.RED), this.leftPos + 195, this.topPos + 5, 0xFFFFFF);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.field_230710_m_.stream().filter(b -> b instanceof BeaconEffectButton).forEach(b -> ((BeaconEffectButton)((Object)b)).renderToolTip(matrixStack, this, mouseX, mouseY));
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (this.field_230706_i_ != null && this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private void renderPlayerPower(MatrixStack matrixStack) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.getCapability(PowerCapabilityProvider.POWER_CAP).ifPresent(power -> {
                float percent = power.get() / 5.0f;
                this.func_238474_b_(matrixStack, this.leftPos + 146, this.topPos + 61, 58, 143, (int)(74.0f * percent), 5);
                MaidBeaconGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)DECIMAL_FORMAT.format(power.get()), (int)(this.leftPos + 240), (int)(this.topPos + 60), (int)0xFFFFFF);
            });
        }
    }

    private TranslationTextComponent getOverflowDeleteButtonText(boolean overflowDelete) {
        return overflowDelete ? new TranslationTextComponent("gui.touhou_little_maid.maid_beacon.overflow_delete_true") : new TranslationTextComponent("gui.touhou_little_maid.maid_beacon.overflow_delete_false");
    }

    private void drawCenteredStringNoShadow(MatrixStack matrixStack, FontRenderer font, String text, int pX, int pY, int color) {
        font.func_238421_b_(matrixStack, text, (float)pX - (float)font.func_78256_a(text) / 2.0f, (float)pY, color);
    }

    private void drawCenteredStringNoShadow(MatrixStack matrixStack, FontRenderer font, ITextComponent text, int pX, int pY, int color) {
        font.func_243248_b(matrixStack, text, (float)pX - (float)font.func_238414_a_((ITextProperties)text) / 2.0f, (float)pY, color);
    }
}

